/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class LongOptionBuilder
extends OptionBuilder<Long> {
    public static final LongType TYPE = new LongType();

    public LongOptionBuilder() {
        super(TYPE);
    }

    public LongOptionBuilder(boolean required) {
        super(TYPE, required);
    }

    public LongOptionBuilder(boolean required, boolean hasArgument) {
        super(TYPE, required, hasArgument);
    }

    public LongOptionBuilder(boolean required, boolean hasArgument, String tokenShort) {
        super(TYPE, required, hasArgument, tokenShort);
    }

    public LongOptionBuilder(boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        super(TYPE, required, hasArgument, tokenShort, tokenLong);
    }

    public static class LongType
    implements OptionType<Long> {
        private LongType() {
        }

        @Override
        public Long convert(String argument) throws OptionType.BadTypeException {
            try {
                return Long.parseLong(argument);
            }
            catch (Exception e) {
                throw new OptionType.BadTypeException(argument, this);
            }
        }

        @Override
        public Long coerce(Object argument) {
            return (Long)argument;
        }

        @Override
        public String getDisplayType() {
            return "long";
        }
    }
}

