/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class IntegerOptionBuilder
extends OptionBuilder<Integer> {
    public static final IntegerType TYPE = new IntegerType();

    public IntegerOptionBuilder() {
        super(TYPE);
    }

    public IntegerOptionBuilder(boolean required) {
        super(TYPE, required);
    }

    public IntegerOptionBuilder(boolean required, boolean hasArgument) {
        super(TYPE, required, hasArgument);
    }

    public IntegerOptionBuilder(boolean required, boolean hasArgument, String tokenShort) {
        super(TYPE, required, hasArgument, tokenShort);
    }

    public IntegerOptionBuilder(boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        super(TYPE, required, hasArgument, tokenShort, tokenLong);
    }

    public static class IntegerType
    implements OptionType<Integer> {
        private IntegerType() {
        }

        @Override
        public Integer convert(String argument) throws OptionType.BadTypeException {
            try {
                return Integer.parseInt(argument);
            }
            catch (Exception e) {
                throw new OptionType.BadTypeException(argument, this);
            }
        }

        @Override
        public Integer coerce(Object argument) {
            return (Integer)argument;
        }

        @Override
        public String getDisplayType() {
            return "integer";
        }
    }
}

