/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class FloatOptionBuilder
extends OptionBuilder<Float> {
    public static final FloatType TYPE = new FloatType();

    public FloatOptionBuilder() {
        super(TYPE);
    }

    public FloatOptionBuilder(boolean required) {
        super(TYPE, required);
    }

    public FloatOptionBuilder(boolean required, boolean hasArgument) {
        super(TYPE, required, hasArgument);
    }

    public FloatOptionBuilder(boolean required, boolean hasArgument, String tokenShort) {
        super(TYPE, required, hasArgument, tokenShort);
    }

    public FloatOptionBuilder(boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        super(TYPE, required, hasArgument, tokenShort, tokenLong);
    }

    public static class FloatType
    implements OptionType<Float> {
        private FloatType() {
        }

        @Override
        public Float convert(String argument) throws OptionType.BadTypeException {
            try {
                return Float.valueOf(Float.parseFloat(argument));
            }
            catch (Exception e) {
                throw new OptionType.BadTypeException(argument, this);
            }
        }

        @Override
        public Float coerce(Object argument) {
            return (Float)argument;
        }

        @Override
        public String getDisplayType() {
            return "float";
        }
    }
}

