/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class DoubleOptionBuilder
extends OptionBuilder<Double> {
    public static final DoubleType TYPE = new DoubleType();

    public DoubleOptionBuilder() {
        super(TYPE);
    }

    public DoubleOptionBuilder(boolean required) {
        super(TYPE, required);
    }

    public DoubleOptionBuilder(boolean required, boolean hasArgument) {
        super(TYPE, required, hasArgument);
    }

    public DoubleOptionBuilder(boolean required, boolean hasArgument, String tokenShort) {
        super(TYPE, required, hasArgument, tokenShort);
    }

    public DoubleOptionBuilder(boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        super(TYPE, required, hasArgument, tokenShort, tokenLong);
    }

    public static class DoubleType
    implements OptionType<Double> {
        private DoubleType() {
        }

        @Override
        public Double convert(String argument) throws OptionType.BadTypeException {
            try {
                return Double.parseDouble(argument);
            }
            catch (Exception e) {
                throw new OptionType.BadTypeException(argument, this);
            }
        }

        @Override
        public Double coerce(Object argument) {
            return (Double)argument;
        }

        @Override
        public String getDisplayType() {
            return "double";
        }
    }
}

