/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class ByteOptionBuilder
extends OptionBuilder<Byte> {
    public static final ByteType TYPE = new ByteType();

    public ByteOptionBuilder() {
        super(TYPE);
    }

    public ByteOptionBuilder(boolean required) {
        super(TYPE, required);
    }

    public ByteOptionBuilder(boolean required, boolean hasArgument) {
        super(TYPE, required, hasArgument);
    }

    public ByteOptionBuilder(boolean required, boolean hasArgument, String tokenShort) {
        super(TYPE, required, hasArgument, tokenShort);
    }

    public ByteOptionBuilder(boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        super(TYPE, required, hasArgument, tokenShort, tokenLong);
    }

    public static class ByteType
    implements OptionType<Byte> {
        private ByteType() {
        }

        @Override
        public Byte convert(String argument) throws OptionType.BadTypeException {
            try {
                return Byte.parseByte(argument);
            }
            catch (Exception e) {
                throw new OptionType.BadTypeException(argument, this);
            }
        }

        @Override
        public Byte coerce(Object argument) {
            return (Byte)argument;
        }

        @Override
        public String getDisplayType() {
            return "byte";
        }
    }
}

