/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser.option;

import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;

public class BooleanOptionBuilder
extends OptionBuilder<Boolean> {
    public static final BooleanType TYPE = new BooleanType();

    public BooleanOptionBuilder() {
        super(TYPE);
    }

    public BooleanOptionBuilder(boolean required) {
        super(TYPE, required);
    }

    public BooleanOptionBuilder(boolean required, boolean hasArgument) {
        super(TYPE, required, hasArgument);
    }

    public BooleanOptionBuilder(boolean required, boolean hasArgument, String tokenShort) {
        super(TYPE, required, hasArgument, tokenShort);
    }

    public BooleanOptionBuilder(boolean required, boolean hasArgument, String tokenShort, String tokenLong) {
        super(TYPE, required, hasArgument, tokenShort, tokenLong);
    }

    public static class BooleanType
    implements OptionType<Boolean> {
        private BooleanType() {
        }

        @Override
        public Boolean convert(String argument) throws OptionType.BadTypeException {
            try {
                return Boolean.parseBoolean(argument);
            }
            catch (Exception e) {
                try {
                    if (Integer.parseInt(argument) != 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception e1) {
                    throw new OptionType.BadTypeException(argument, this);
                }
            }
        }

        @Override
        public Boolean coerce(Object argument) {
            return (Boolean)argument;
        }

        @Override
        public String getDisplayType() {
            return "boolean";
        }
    }
}

