/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser;

import java.util.ArrayList;
import java.util.HashMap;
import net.javamon.dev.utils.commandParser.option.BooleanOptionBuilder;
import net.javamon.dev.utils.commandParser.option.ByteOptionBuilder;
import net.javamon.dev.utils.commandParser.option.CharacterOptionBuilder;
import net.javamon.dev.utils.commandParser.option.DoubleOptionBuilder;
import net.javamon.dev.utils.commandParser.option.FloatOptionBuilder;
import net.javamon.dev.utils.commandParser.option.IntegerOptionBuilder;
import net.javamon.dev.utils.commandParser.option.LongOptionBuilder;
import net.javamon.dev.utils.commandParser.option.Option;
import net.javamon.dev.utils.commandParser.option.OptionBuilder;
import net.javamon.dev.utils.commandParser.option.OptionType;
import net.javamon.dev.utils.commandParser.option.ShortOptionBuilder;
import net.javamon.dev.utils.commandParser.option.StringOptionBuilder;

public class OptionMap {
    private ArrayList<Option<?>> options = new ArrayList();
    private HashMap<String, Option<?>> optionMap = new HashMap();
    private final String helpOptionShort;
    private final String helpOptionLong;

    public OptionMap(Option<?> helpOption) {
        if (helpOption != null) {
            this.put(helpOption);
            this.helpOptionShort = helpOption.getTokenShort();
            this.helpOptionLong = helpOption.getTokenLong();
        } else {
            this.helpOptionShort = null;
            this.helpOptionLong = null;
        }
    }

    public OptionMap(OptionBuilder<?> helpOptionBuilder) {
        this(helpOptionBuilder.build());
    }

    public OptionMap() {
        this((Option<?>)null);
    }

    public void put(Option<?> option) {
        if (option.getTokenLong() != null) {
            if (this.optionMap.get(option.getTokenLong()) != null) {
                throw new RuntimeException("option '" + option.getTokenLong() + "' already exists in the option map");
            }
            this.optionMap.put(option.getTokenLong(), option);
        }
        if (option.getTokenShort() != null) {
            if (this.optionMap.get(option.getTokenShort()) != null) {
                throw new RuntimeException("option '" + option.getTokenShort() + "' already exists in the option map");
            }
            this.optionMap.put(option.getTokenShort(), option);
        }
        this.options.add(option);
    }

    public void put(OptionBuilder<?> optionBuilder) {
        this.put(optionBuilder.build());
    }

    public Boolean getBoolean(String token) {
        return this.getValue(token, BooleanOptionBuilder.TYPE);
    }

    public Byte getByte(String token) {
        return this.getValue(token, ByteOptionBuilder.TYPE);
    }

    public Character getChar(String token) {
        return this.getValue(token, CharacterOptionBuilder.TYPE);
    }

    public Double getDouble(String token) {
        return this.getValue(token, DoubleOptionBuilder.TYPE);
    }

    public Float getFloat(String token) {
        return this.getValue(token, FloatOptionBuilder.TYPE);
    }

    public Integer getInt(String token) {
        return this.getValue(token, IntegerOptionBuilder.TYPE);
    }

    public Long getLong(String token) {
        return this.getValue(token, LongOptionBuilder.TYPE);
    }

    public Short getShort(String token) {
        return this.getValue(token, ShortOptionBuilder.TYPE);
    }

    public String getString(String token) {
        return this.getValue(token, StringOptionBuilder.TYPE);
    }

    public <T> T getValue(String token, OptionType<T> type) {
        Object toReturn = this.optionMap.get(token).getArgument();
        if (toReturn == null) {
            return null;
        }
        return type.coerce(toReturn);
    }

    public Boolean getBoolean(Option<Boolean> option) {
        return this.getValue(option);
    }

    public Byte getByte(Option<Byte> option) {
        return this.getValue(option);
    }

    public Character getChar(Option<Character> option) {
        return this.getValue(option);
    }

    public Double getDouble(Option<Double> option) {
        return this.getValue(option);
    }

    public Float getFloat(Option<Float> option) {
        return this.getValue(option);
    }

    public Integer getInt(Option<Integer> option) {
        return this.getValue(option);
    }

    public Long getLong(Option<Long> option) {
        return this.getValue(option);
    }

    public Short getShort(Option<Short> option) {
        return this.getValue(option);
    }

    public String getString(Option<String> option) {
        return this.getValue(option);
    }

    public <T> T getValue(Option<T> option) {
        if (option.getTokenLong() != null) {
            return this.getValue(option.getTokenLong(), option.getType());
        }
        return this.getValue(option.getTokenShort(), option.getType());
    }

    public void resetForParse() {
        int i = 0;
        while (i < this.options.size()) {
            this.options.get(i).clearArgument();
            ++i;
        }
    }

    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.options.size()) {
            builder.append(String.valueOf(this.options.get(i).getHelp("  ")) + "\n");
            ++i;
        }
        return builder.toString();
    }

    protected boolean isHelp(String token) {
        return token.equals(this.helpOptionShort) || token.equals(this.helpOptionLong);
    }

    protected Option<?> get(String token) {
        if (token == null) {
            return null;
        }
        return this.optionMap.get(token);
    }

    protected ArrayList<Option<?>> getOptions() {
        return this.options;
    }
}

