/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.commandParser;

import net.javamon.dev.utils.commandParser.OptionMap;
import net.javamon.dev.utils.commandParser.option.Option;
import net.javamon.dev.utils.commandParser.option.OptionType;

public final class CommandLineParser {
    private CommandLineParser() {
        throw new AssertionError();
    }

    public static boolean parse(String[] args, int startFrom, OptionMap options) throws UnknownOptionException, MissingArgumentException, MissingOptionException, OptionType.BadTypeException, MultipleDefinitionException {
        if (startFrom < 0) {
            startFrom = 0;
        }
        options.resetForParse();
        int i = startFrom;
        while (i < args.length) {
            Option<?> option;
            String stripped = Option.strip(args[i]);
            String strippedArg = Option.stripArg(args[i]);
            if (strippedArg != null) {
                stripped = stripped.substring(0, stripped.indexOf(strippedArg) - 1);
            }
            if (!CommandLineParser.isOption(args[i], stripped, options) || strippedArg != null && Option.wasShort(args[i], stripped)) {
                throw new UnknownOptionException(args[i]);
            }
            if (options.isHelp(stripped)) {
                return true;
            }
            if (strippedArg != null) {
                option = options.get(stripped);
                option.setArgument(strippedArg);
            } else if (!CommandLineParser.parseCompoundFlags(args[i], stripped, options)) {
                option = options.get(stripped);
                if (option.hasArgument() && !Option.wasShort(args[i], stripped)) {
                    throw new MissingArgumentException(args[i]);
                }
                if (!option.hasArgument()) {
                    try {
                        option.getType().coerce(true);
                        if (option.getArgumentNoDefault() != null) {
                            throw new MultipleDefinitionException(stripped);
                        }
                        option.setArgument("true");
                    }
                    catch (ClassCastException e) {
                        throw new OptionType.BadTypeException(stripped, option.getType());
                    }
                } else {
                    String strippedToken;
                    String nextToken = i < args.length - 1 ? args[i + 1] : null;
                    String string = strippedToken = nextToken != null ? Option.strip(nextToken) : null;
                    if (nextToken == null || CommandLineParser.isOption(nextToken, strippedToken, options)) {
                        throw new MissingArgumentException(args[i]);
                    }
                    if (option.getArgumentNoDefault() != null) {
                        throw new MultipleDefinitionException(stripped);
                    }
                    option.setArgument(nextToken);
                    ++i;
                }
            }
            ++i;
        }
        for (Option<?> option : options.getOptions()) {
            if (!option.isRequired() || option.getArgumentNoDefault() != null) continue;
            throw new MissingOptionException(option);
        }
        return false;
    }

    private static boolean parseCompoundFlags(String token, String stripped, OptionMap options) throws OptionType.BadTypeException, MultipleDefinitionException {
        if (CommandLineParser.isCompoundFlag(token, stripped, options)) {
            int i = 0;
            while (i < stripped.length()) {
                Option<?> option = options.get(String.valueOf(stripped.charAt(i)));
                try {
                    option.getType().coerce(true);
                    if (option.getArgumentNoDefault() != null) {
                        throw new MultipleDefinitionException(String.valueOf(stripped.charAt(i)));
                    }
                    option.setArgument("true");
                }
                catch (ClassCastException e) {
                    throw new OptionType.BadTypeException(stripped, option.getType());
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean isCompoundFlag(String token, String stripped, OptionMap options) {
        if (token == null || stripped == null || stripped.length() < 2 || !Option.wasShort(token, stripped)) {
            return false;
        }
        int i = 0;
        while (i < stripped.length()) {
            Option<?> option = options.get(String.valueOf(stripped.charAt(i)));
            if (option == null || option.hasArgument()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isOption(String token, String stripped, OptionMap options) {
        if (token == null) {
            return false;
        }
        Option<?> option = options.get(stripped);
        return option != null || CommandLineParser.isCompoundFlag(token, stripped, options);
    }

    public static class MissingArgumentException
    extends Exception {
        private static final long serialVersionUID = 8551170025122609692L;
        public final String token;

        private MissingArgumentException(String token) {
            super("missing argument: " + token);
            this.token = token;
        }
    }

    public static class MissingOptionException
    extends Exception {
        private static final long serialVersionUID = -8815998552688754516L;
        public final Option<?> option;

        private MissingOptionException(Option<?> option) {
            super("required but missing: " + option.getTokens());
            this.option = option;
        }
    }

    public static class MultipleDefinitionException
    extends Exception {
        private static final long serialVersionUID = -1106956430755619796L;
        public final String token;

        private MultipleDefinitionException(String token) {
            super("multiple definitions: " + token);
            this.token = token;
        }
    }

    public static class UnknownOptionException
    extends Exception {
        private static final long serialVersionUID = -8861800081454842412L;
        public final String token;

        private UnknownOptionException(String token) {
            super("unrecognized command: " + token);
            this.token = token;
        }
    }
}

