/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.comboBox;

import java.awt.Component;
import javax.swing.JList;
import net.javamon.dev.utils.comboBox.AbstractMultiplexableRenderer;

public class ToolTipRenderer
extends AbstractMultiplexableRenderer {
    private static final long serialVersionUID = -106418108287480218L;
    private boolean forceDefault = false;
    private String defaultToolTip;
    private String[] toolTips;

    public ToolTipRenderer() {
        this(null, null);
    }

    public ToolTipRenderer(String[] toolTips) {
        this(toolTips, null);
    }

    public ToolTipRenderer(String[] toolTips, String defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
        this.toolTips = toolTips;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (index > -1 && this.toolTips != null && !this.forceDefault) {
            list.setToolTipText(this.toolTips[index]);
        } else {
            list.setToolTipText(this.defaultToolTip);
        }
        return c;
    }

    public void setToolTips(String[] toolTips) {
        this.toolTips = toolTips;
    }

    public void setDefaultToolTip(String defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    public void forceUseDefault(boolean forceDefault) {
        this.forceDefault = forceDefault;
    }
}

