/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.comboBox;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JList;
import javax.swing.UIManager;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.comboBox.AbstractMultiplexableRenderer;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.AbstractActionListener;

public class ToggleableItemRenderer<T>
extends AbstractMultiplexableRenderer {
    private static final long serialVersionUID = 8317954982945648235L;
    private boolean[] entries;
    private BoxListener<T> boxListener;

    public ToggleableItemRenderer(ExtendableJComboBox<T> box, String errorMessageKey) {
        this.boxListener = new BoxListener(box, errorMessageKey);
        box.addActionListener(this.boxListener);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (this.entries == null || index == -1 || this.entries[index]) {
            c.setForeground(super.getForeground());
            c.setBackground(super.getBackground());
        } else {
            c.setForeground(Color.lightGray);
            if (isSelected) {
                c.setBackground(UIManager.getColor("ComboBox.background"));
            } else {
                c.setBackground(super.getBackground());
            }
        }
        return c;
    }

    public boolean isSelectable(int index) {
        return this.entries == null || this.entries[index];
    }

    public boolean[] getEntries() {
        return this.entries;
    }

    public void setEntries(boolean[] entries) {
        this.entries = entries;
    }

    public void validateIndex() {
        ((BoxListener)this.boxListener).validateIndex(false);
    }

    private class BoxListener<E>
    extends AbstractActionListener {
        private final ExtendableJComboBox<E> box;
        private final String errorMessageKey;

        private BoxListener(ExtendableJComboBox<E> box, String errorMessageKey) {
            this.box = box;
            this.errorMessageKey = errorMessageKey;
        }

        @Override
        public void performAction(ActionEvent e) {
            this.validateIndex(true);
        }

        private void validateIndex(boolean showError) {
            if (ToggleableItemRenderer.this.entries == null) {
                return;
            }
            if (!ToggleableItemRenderer.this.entries[this.box.getSelectedIndex()]) {
                if (showError && this.errorMessageKey != null && this.errorMessageKey.length() > 0) {
                    Prompt.error(Resources.__("appSelectErrorH", new Object[0]), Resources.__(this.errorMessageKey, this.box.getSelectedItem()));
                }
                boolean foundEntry = false;
                int i = 0;
                while (i < ToggleableItemRenderer.this.entries.length) {
                    if (ToggleableItemRenderer.this.entries[i]) {
                        this.box.setSelectedIndex(i);
                        foundEntry = true;
                        break;
                    }
                    ++i;
                }
                if (!foundEntry) {
                    this.box.setSelectedIndex(0);
                }
            }
        }
    }
}

