/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.comboBox;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.javamon.dev.utils.comboBox.AbstractMultiplexableRenderer;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;

public class MultiplexRenderer
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = -7061094859113315819L;
    private AbstractMultiplexableRenderer[] renderers;

    public MultiplexRenderer(ExtendableJComboBox box, AbstractMultiplexableRenderer ... renderers) {
        this.renderers = renderers;
        box.setRenderer(this);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.renderers == null) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        Component next = this.renderers[0].getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        int i = 1;
        while (i < this.renderers.length) {
            this.renderers[i].setComponent(next);
            next = this.renderers[i].getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            ++i;
        }
        return next;
    }

    public void setRenderers(AbstractMultiplexableRenderer ... renderers) {
        this.renderers = renderers;
    }

    public AbstractMultiplexableRenderer getRenderer(int index) {
        if (this.renderers != null && this.renderers.length > 0 && index < this.renderers.length && index >= 0) {
            return this.renderers[index];
        }
        return null;
    }

    public AbstractMultiplexableRenderer[] getRenderers() {
        return this.renderers;
    }
}

