/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.comboBox;

import java.awt.Dimension;
import javax.swing.JComboBox;

public final class JComboBoxHelper {
    private JComboBoxHelper() {
        throw new AssertionError();
    }

    public static void load(JComboBox<String> box, String[] entries, String lastEntry, boolean allowResize) {
        if (entries == null) {
            return;
        }
        Dimension d = box.getPreferredSize();
        box.setModel(new JComboBox<String>(entries).getModel());
        if (lastEntry != null) {
            box.addItem(lastEntry);
        }
        if (!allowResize) {
            box.setPreferredSize(d);
        }
    }

    public static void load(JComboBox<String> box, boolean allowResize, String ... entries) {
        JComboBoxHelper.load(box, entries, null, allowResize);
    }

    public static void load(JComboBox<String> box, int numEntries, boolean allowResize) {
        String[] entries = new String[numEntries];
        int i = 0;
        while (i < numEntries) {
            entries[i] = String.valueOf(i);
            ++i;
        }
        JComboBoxHelper.load(box, allowResize, entries);
    }
}

