/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.comboBox;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class ExtendablePopupMenuListener
implements PopupMenuListener {
    private boolean scroll;
    private boolean extend;
    private int maxWidth;
    private JScrollPane scrollPane;

    protected ExtendablePopupMenuListener() {
        this(false, true, -1);
    }

    protected ExtendablePopupMenuListener(int maximumWidth) {
        this(true, true, maximumWidth);
    }

    protected ExtendablePopupMenuListener(boolean scroll, boolean extend, int maxWidth) {
        this.setScroll(scroll);
        this.setMaxWidth(maxWidth);
        this.setExtendPopup(extend);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        if (comboBox.getItemCount() == 0) {
            return;
        }
        final Accessible child = comboBox.getAccessibleContext().getAccessibleChild(0);
        if (child instanceof BasicComboPopup) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtendablePopupMenuListener.this.customizePopup((BasicComboPopup)child);
                }
            });
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.scrollPane != null) {
            this.scrollPane.setHorizontalScrollBar(null);
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public boolean isExtendable() {
        return this.extend;
    }

    public void setExtendPopup(boolean extend) {
        this.extend = extend;
    }

    public boolean isScroll() {
        return this.scroll;
    }

    public void setScroll(boolean scroll) {
        this.scroll = scroll;
    }

    protected void customizePopup(BasicComboPopup popup) {
        this.scrollPane = this.getScrollPane(popup);
        if (this.extend) {
            this.extendPopup(popup);
        }
        this.checkHorizontalScrollBar(popup);
        Component comboBox = popup.getInvoker();
        Point location = comboBox.getLocationOnScreen();
        int height = comboBox.getPreferredSize().height;
        popup.setLocation(location.x, location.y + height - 1);
        popup.setLocation(location.x, location.y + height);
    }

    protected void extendPopup(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        int popupWidth = list.getPreferredSize().width + 5 + this.getScrollBarWidth(popup, this.scrollPane);
        if (this.maxWidth != -1) {
            popupWidth = Math.min(popupWidth, this.maxWidth);
        }
        Dimension scrollPaneSize = this.scrollPane.getPreferredSize();
        scrollPaneSize.width = popupWidth = Math.max(popupWidth, scrollPaneSize.width);
        this.scrollPane.setPreferredSize(scrollPaneSize);
        this.scrollPane.setMaximumSize(scrollPaneSize);
    }

    private void checkHorizontalScrollBar(BasicComboPopup popup) {
        JViewport viewport = this.scrollPane.getViewport();
        Point p = viewport.getViewPosition();
        p.x = 0;
        viewport.setViewPosition(p);
        if (!this.scroll) {
            this.scrollPane.setHorizontalScrollBar(null);
            return;
        }
        JScrollBar horizontal = this.scrollPane.getHorizontalScrollBar();
        if (horizontal == null) {
            horizontal = new JScrollBar(0);
            this.scrollPane.setHorizontalScrollBar(horizontal);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
        }
        if (this.horizontalScrollBarWillBeVisible(popup, this.scrollPane)) {
            Dimension scrollPaneSize = this.scrollPane.getPreferredSize();
            scrollPaneSize.height += horizontal.getPreferredSize().height;
            this.scrollPane.setPreferredSize(scrollPaneSize);
            this.scrollPane.setMaximumSize(scrollPaneSize);
            this.scrollPane.revalidate();
        }
    }

    protected JScrollPane getScrollPane(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        return (JScrollPane)c;
    }

    protected int getScrollBarWidth(BasicComboPopup popup, JScrollPane scrollPane) {
        int scrollBarWidth = 0;
        JComboBox comboBox = (JComboBox)popup.getInvoker();
        if (comboBox.getItemCount() > comboBox.getMaximumRowCount()) {
            JScrollBar vertical = scrollPane.getVerticalScrollBar();
            scrollBarWidth = vertical.getPreferredSize().width;
        }
        return scrollBarWidth;
    }

    protected boolean horizontalScrollBarWillBeVisible(BasicComboPopup popup, JScrollPane scrollPane) {
        JList<Object> list = popup.getList();
        int scrollBarWidth = this.getScrollBarWidth(popup, scrollPane);
        int popupWidth = list.getPreferredSize().width + scrollBarWidth;
        return popupWidth > scrollPane.getPreferredSize().width;
    }
}

