/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils.comboBox;

import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import net.javamon.dev.utils.comboBox.ExtendablePopupMenuListener;

public class ExtendableJComboBox<T>
extends JComboBox<T> {
    private static final long serialVersionUID = -9131202364832045647L;
    private ExtendablePopupMenuListener boxListener;

    public ExtendableJComboBox() {
        this.initialize();
    }

    public ExtendableJComboBox(T[] items) {
        super(items);
        this.initialize();
    }

    public ExtendableJComboBox(Vector<T> items) {
        super(items);
        this.initialize();
    }

    public ExtendableJComboBox(ComboBoxModel<T> aModel) {
        super(aModel);
        this.initialize();
    }

    @Override
    public void setSelectedIndex(int anIndex) {
        if (anIndex == 0 && this.getItemCount() == 0) {
            anIndex = -1;
        }
        super.setSelectedIndex(anIndex);
    }

    public void setSelectedIndexNoAction(int index) {
        if (this.getSelectedIndex() == index) {
            return;
        }
        ActionListener[] listeners = this.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeActionListener(listeners[i]);
            ++i;
        }
        this.setSelectedIndex(index);
        i = 0;
        while (i < listeners.length) {
            this.addActionListener(listeners[i]);
            ++i;
        }
    }

    private void initialize() {
        InputMap map = this.getInputMap(1);
        map.getParent().remove(KeyStroke.getKeyStroke("pressed SPACE"));
        map.getParent().put(KeyStroke.getKeyStroke(32, 64), "spacePopup");
        map.getParent().put(KeyStroke.getKeyStroke(32, 128), "spacePopup");
        if (this.boxListener == null) {
            this.addPopupMenuListener(new ExtendablePopupMenuListener());
        }
    }
}

