/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

public final class WordWrap {
    public static final int NONE = 0;
    public static final int TEXT = 1;
    public static final int STRING = 2;
    public static final int NEWLINE = 3;
    private static final String CHAR_NEWLINE = "\n";
    private static final String CHAR_WAIT = "\f";
    private static final String CHAR_CLEAR = "\b";
    private static final String CHAR_DELAY = "\r";
    private static final String CTRL_NEWLINE = "\\n";
    private static final String CTRL_WAIT = "\\f";
    private static final String CTRL_CLEAR = "\\b";
    private static final String CTRL_DELAY = "\\r";
    private static final String INDENT = "        ";
    private static final String CTRL_EOL = "\\";
    private static final int DEFAULT_CHARS = 100;

    private WordWrap() {
        throw new AssertionError();
    }

    public static String unwrap(String toUnwrap, int type) {
        if (toUnwrap == null) {
            return toUnwrap;
        }
        if (type == 3) {
            return toUnwrap;
        }
        if (type == 2) {
            return toUnwrap.replace(CHAR_NEWLINE, CTRL_NEWLINE).replace(CHAR_WAIT, CTRL_WAIT).replace(CHAR_CLEAR, CTRL_CLEAR).replace(CHAR_DELAY, CTRL_DELAY);
        }
        if (type == 1) {
            return toUnwrap;
        }
        return toUnwrap;
    }

    public static String wrap(String key, String toWrap, int type) {
        return WordWrap.wrap(key, toWrap, 100, type);
    }

    public static String wrap(String key, String toWrap, int width, int type) {
        return WordWrap.wrap(String.valueOf(key) + "=" + toWrap, width, type).substring(key.length() + 1);
    }

    public static String wrap(String toWrap, int type) {
        return WordWrap.wrap(toWrap, 100, type);
    }

    public static String wrap(String toWrap, int width, int type) {
        if (type == 0) {
            return toWrap;
        }
        StringBuilder builder = new StringBuilder();
        String processed = WordWrap.preprocess(toWrap, type);
        String[] tokens = processed.split(CHAR_NEWLINE);
        int i = 0;
        while (i < tokens.length) {
            builder.append(WordWrap.wrapLine(tokens[i], width));
            if (i < tokens.length - 1) {
                builder.append(CHAR_NEWLINE);
            }
            ++i;
        }
        return builder.toString();
    }

    private static String preprocess(String toProcess, int type) {
        if (type == 3) {
            String processed = toProcess.replace(CHAR_NEWLINE, CTRL_NEWLINE).replace(CTRL_WAIT, "").replace(CTRL_CLEAR, "");
            return WordWrap.processControls(processed);
        }
        if (type == 2) {
            return WordWrap.processControls(WordWrap.processNewlines(toProcess));
        }
        if (type == 1) {
            return WordWrap.processNewlines(toProcess);
        }
        return toProcess;
    }

    private static String processNewlines(String toWrap) {
        StringBuilder builder = new StringBuilder();
        boolean newlineMode = false;
        int i = 0;
        while (i < toWrap.length()) {
            if (toWrap.charAt(i) == '\n') {
                if (!WordWrap.isNewlineControl(toWrap, i)) {
                    builder.append("\\\n        ");
                    newlineMode = true;
                }
            } else if (!newlineMode || toWrap.charAt(i) != ' ' && toWrap.charAt(i) != '\t') {
                builder.append(toWrap.charAt(i));
                newlineMode = false;
            }
            ++i;
        }
        return builder.toString();
    }

    private static String processControls(String toWrap) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < toWrap.length()) {
            int longestControl = WordWrap.longestControlSequence(toWrap, i);
            if (longestControl == 0 || i + longestControl == toWrap.length()) {
                builder.append(toWrap.charAt(i));
            } else {
                builder.append("\\\n        " + toWrap.substring(i, longestControl + i));
                i += longestControl - 1;
            }
            ++i;
        }
        return builder.toString();
    }

    private static int longestControlSequence(String toWrap, int start) {
        int toReturn = 0;
        int index = start;
        while (true) {
            if (toWrap.startsWith(CTRL_NEWLINE, index)) {
                toReturn += CTRL_NEWLINE.length();
                index += CTRL_NEWLINE.length();
                continue;
            }
            if (toWrap.startsWith(CTRL_WAIT, index)) {
                toReturn += CTRL_WAIT.length();
                index += CTRL_WAIT.length();
                continue;
            }
            if (!toWrap.startsWith(CTRL_CLEAR, index)) break;
            toReturn += CTRL_CLEAR.length();
            index += CTRL_CLEAR.length();
        }
        return toReturn;
    }

    private static String wrapLine(String toWrap, int width) {
        if (toWrap.length() < width) {
            return toWrap;
        }
        int pivot = toWrap.lastIndexOf(32, width - 1 - CTRL_EOL.length() - 1);
        if (pivot > INDENT.length()) {
            String before = toWrap.substring(0, pivot);
            String after = toWrap.substring(pivot + 1);
            return String.valueOf(WordWrap.wrapLine(String.valueOf(before) + ' ' + CTRL_EOL, width)) + CHAR_NEWLINE + WordWrap.wrapLine(INDENT + after.trim(), width);
        }
        pivot = width - CTRL_EOL.length() - 1;
        String before = toWrap.substring(0, pivot);
        String after = toWrap.substring(pivot + 1);
        return String.valueOf(WordWrap.wrapLine(String.valueOf(before) + CTRL_EOL, width)) + CHAR_NEWLINE + WordWrap.wrapLine(INDENT + after.trim(), width);
    }

    private static boolean isNewlineControl(String toWrap, int i) {
        int length = CTRL_NEWLINE.length();
        String toCheck = null;
        if (i < toWrap.length() - length) {
            toCheck = toWrap.substring(i, i + length);
        } else if (i > length) {
            toCheck = toWrap.substring(i - length, i + 1);
        }
        return toCheck != null && (toCheck.equals("\n\\n") || toCheck.equals("\\n\n") || toCheck.equals("\n\\f") || toCheck.equals("\\f\n") || toCheck.equals("\n\\b") || toCheck.equals("\\b\n"));
    }
}

