/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RotatedLabel
extends JPanel {
    private static final long serialVersionUID = 756382932580674435L;
    private static final int LABEL_PADDING = 2;
    private Graphics2D g2d;
    private int rotation;
    private JLabel label;
    private int deltaY;

    public RotatedLabel(int rotation) {
        this.rotation = rotation;
        this.setOpaque(false);
        this.label = new JMoveableLabel();
        this.add(this.label);
    }

    public RotatedLabel(String text, int rotation) {
        this.rotation = rotation;
        this.setOpaque(false);
        this.label = new JMoveableLabel();
        this.label.setText(text);
        this.add(this.label);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.label.getPreferredSize();
        int tempWidth = d.width + 2;
        int tempHeight = d.height + 2;
        double radians = Math.toRadians(this.rotation);
        double cos = Math.abs(Math.cos(radians));
        double sin = Math.abs(Math.sin(radians));
        d.width = (int)((double)tempWidth * cos + (double)tempHeight * sin);
        d.height = (int)((double)tempWidth * sin + (double)tempHeight * cos);
        this.deltaY = d.height - tempHeight;
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.g2d = (Graphics2D)g;
        this.g2d.rotate(Math.toRadians(this.rotation), (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(this.g2d);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    private class JMoveableLabel
    extends JLabel {
        private static final long serialVersionUID = -9205099315237873851L;

        private JMoveableLabel() {
        }

        @Override
        public int getY() {
            return super.getY() + RotatedLabel.this.deltaY / 2;
        }
    }
}

