/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import net.javamon.dev.Resources;

public class RelativeFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 6973172865577057876L;

    private RelativeFileChooser() {
        this.setCurrentDirectory(new File("."));
    }

    private RelativeFileChooser(FileSystemView fsv) {
        super(fsv);
        this.setCurrentDirectory(new File("."));
    }

    private RelativeFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.setCurrentDirectory(new File("."));
    }

    private RelativeFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.setCurrentDirectory(new File("."));
    }

    private RelativeFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.setCurrentDirectory(new File("."));
    }

    private RelativeFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.setCurrentDirectory(new File("."));
    }

    public static RelativeFileChooser build(String promptKey, int width, boolean multiSelect) {
        RelativeFileChooser chooser = RelativeFileChooser.build(promptKey, width, 1, null, multiSelect);
        return chooser;
    }

    public static RelativeFileChooser build(String promptKey, boolean multiSelect) {
        return RelativeFileChooser.build(promptKey, -1, multiSelect);
    }

    public static RelativeFileChooser build(String promptKey, String fileExt, int width, boolean multiSelect) {
        RelativeFileChooser chooser = RelativeFileChooser.build(promptKey, width, 0, Resources.fileType(fileExt), multiSelect);
        return chooser;
    }

    public static RelativeFileChooser build(String promptKey, String fileExt, boolean multiSelect) {
        return RelativeFileChooser.build(promptKey, fileExt, -1, multiSelect);
    }

    public static RelativeFileChooser build(String promptKey, int width, int mode, FileFilter filter, boolean multiSelect) {
        RelativeFileChooser chooser = new RelativeFileChooser();
        chooser.setDialogTitle(Resources.__(promptKey, new Object[0]));
        if (width > 0) {
            chooser.setMinimumSize(new Dimension(width, chooser.getMinimumSize().height));
            chooser.setPreferredSize(new Dimension(width, chooser.getPreferredSize().height));
            chooser.setMaximumSize(new Dimension(width, chooser.getMaximumSize().height));
        }
        chooser.setFileSelectionMode(mode);
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        chooser.setMultiSelectionEnabled(multiSelect);
        return chooser;
    }
}

