/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Color;
import javax.swing.JTextField;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.Validate;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;

public class PanelPercent
extends AbstractPanel {
    private static final Color TEXT_COLOR = new Color(175, 175, 175, 255);
    private static final String TEST_STRING = "-100.00%";
    public JTextField p;
    private JLabelHTML label;
    private boolean noConstrain;
    private final boolean inverse;
    private final int minValue;
    private final int maxValue;

    public PanelPercent(int width, int minValue, int maxValue, boolean isDivisor, String tooltipKey, AbstractPanel parent) {
        this.inverse = isDivisor;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.noConstrain = false;
        if (parent == null) {
            parent = this;
        }
        this.setP(width, tooltipKey, parent);
        JLabelHTML testLabel = new JLabelHTML(TEST_STRING, -1);
        this.setPreferredSize(testLabel.getPreferredSize().width + 5 + this.p.getPreferredSize().width, this.p.getPreferredSize().height);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.p.setEnabled(enabled);
    }

    @Override
    public void validate() {
        if (!this.noConstrain) {
            Validate.textConstrainInt(this.p, this.minValue, this.maxValue);
        }
        float value = Float.parseFloat(this.p.getText());
        value = this.inverse && value != 0.0f ? 100.0f / value : (this.inverse ? 0.0f : (value *= 100.0f / (float)this.maxValue));
        this.label.setText(Resources.__("mainPercent", Float.valueOf(value)));
    }

    public boolean isEnabled() {
        return this.p.isEnabled();
    }

    public void setText(String text) {
        this.p.setText(text);
    }

    public String getText() {
        return this.p.getText();
    }

    public void setToolTipText(String tooltipKey, Object ... args) {
        if (args == null || args.length == 0) {
            this.p.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        } else {
            this.p.setToolTipText(HTML.wrap(Resources.__(tooltipKey, args)));
        }
    }

    private void setP(int width, String tooltipKey, AbstractPanel parent) {
        this.p = new JTextField(width){
            private static final long serialVersionUID = -3213980617903802763L;

            @Override
            public void setText(String text) {
                if (text != this.getText() && !text.equals(this.getText())) {
                    super.setText(text);
                    PanelPercent.this.validate();
                }
            }
        };
        this.p.setToolTipText(HTML.wrap(Resources.__(tooltipKey, new Object[0])));
        this.p.addFocusListener(new ValidateFocusListener(parent));
        this.p.addKeyListener(new ValidateKeyListener(parent));
        this.layout("East", this.p, 0, "East", this.panel);
        this.layout("North", this.p, 0, "North", this.panel);
        this.add(this.p);
        this.label = this.createLabel(null, null);
        this.label.setAlignmentX(4.0f);
        this.label.setForeground(TEXT_COLOR);
        this.layout("East", this.label, -5, "West", this.p);
        this.layout("North", this.label, 0, "North", this.panel);
        this.add(this.label);
    }
}

