/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.javamon.dev.ImageCache;

public class PanelImage
extends JPanel {
    private static final long serialVersionUID = -7475969367975142549L;
    private BufferedImage image;
    private ImageCache.BufferedImageData imageData;
    private BufferedImage imageRegion;
    private boolean useRegion;

    public PanelImage(BufferedImage image) {
        this.setOpaque(false);
        this.clearRegion();
        this.image = image;
    }

    public PanelImage(ImageCache.BufferedImageData imageData) {
        this.setOpaque(false);
        this.clearRegion();
        this.imageData = imageData;
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage toDraw;
        super.paintComponent(g);
        if (this.imageRegion != null) {
            toDraw = this.imageRegion;
        } else {
            if (this.useRegion) {
                return;
            }
            if (this.image != null) {
                toDraw = this.image;
            } else if (this.imageData != null) {
                toDraw = this.imageData.get();
            } else {
                return;
            }
        }
        Dimension d = this.getPreferredSize();
        if (toDraw.getWidth() >= d.width || toDraw.getHeight() >= d.height) {
            g.drawImage(toDraw, 0, 0, this);
        } else {
            int x = d.width / 2 - toDraw.getWidth() / 2;
            int y = d.height / 2 - toDraw.getHeight() / 2;
            g.drawImage(toDraw, x, y, this);
        }
    }

    public int getRegionWidth() {
        if (this.imageRegion != null) {
            return this.imageRegion.getWidth();
        }
        return 0;
    }

    public int getRegionHeight() {
        if (this.imageRegion != null) {
            return this.imageRegion.getHeight();
        }
        return 0;
    }

    public void setImage(BufferedImage image) {
        if (this.imageData == null) {
            this.image = image;
        }
    }

    public void setImage(ImageCache.BufferedImageData imageData) {
        if (this.image == null) {
            this.imageData = imageData;
        }
    }

    public void dispose() {
        this.clearRegion();
        this.image = null;
        this.imageData = null;
    }

    public void clearRegion() {
        this.useRegion = false;
        this.imageRegion = null;
        this.repaint();
    }

    public void setRegion(int x, int y) {
        this.clearRegion();
        if (this.imageData != null) {
            this.imageRegion = this.imageData.get().getSubimage(x, y, this.image.getWidth(), this.image.getHeight());
        } else if (this.image != null) {
            this.imageRegion = this.image.getSubimage(x, y, this.image.getWidth(), this.image.getHeight());
        }
    }

    public void setRegion(int x, int y, int width, int height) {
        this.clearRegion();
        if (this.imageData != null) {
            this.imageRegion = this.imageData.get().getSubimage(x, y, width, height);
        } else if (this.image != null) {
            this.imageRegion = this.image.getSubimage(x, y, width, height);
        }
    }
}

