/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class PanelColor {
    public final JPanel panel = new JPanel(){
        private static final long serialVersionUID = 8047309010529897270L;

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    };

    public PanelColor(int red, int green, int blue, int alpha, int width, int height, int borderWidth) {
        this(new Color(red, green, blue, alpha), width, height, borderWidth);
    }

    public PanelColor(Color color, int width, int height, int borderWidth) {
        this.panel.setOpaque(false);
        if (borderWidth > 0) {
            this.panel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), borderWidth));
        }
        this.panel.setPreferredSize(new Dimension(width, height));
        this.panel.setBackground(color);
    }

    public Color getColor() {
        return this.panel.getBackground();
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.setColor(new Color(red, green, blue, alpha));
    }

    public void setColor(Color color) {
        this.panel.setBackground(color);
    }
}

