/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class JTextAreaRestricted
extends JTextArea {
    private static final long serialVersionUID = -4754204593860852380L;
    private final boolean allowNewline;
    private final boolean allowTab;

    public JTextAreaRestricted(String text, int rows, int columns, boolean allowNewline, boolean allowTab) {
        super(text, rows, columns);
        this.setTabSize(4);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.allowNewline = allowNewline;
        this.allowTab = allowTab;
        InputMap defaultMap = this.getInputMap();
        if (!allowNewline) {
            defaultMap.remove(KeyStroke.getKeyStroke('\n'));
            defaultMap.remove(KeyStroke.getKeyStroke('\r'));
        }
        if (!allowTab) {
            defaultMap.remove(KeyStroke.getKeyStroke('\t'));
        }
        this.setInputMap(0, defaultMap);
    }

    @Override
    public void insert(String str, int pos) {
        super.insert(this.replace(str), pos);
    }

    @Override
    public void append(String str) {
        super.append(this.replace(str));
    }

    @Override
    public void replaceRange(String str, int start, int end) {
        super.replaceRange(this.replace(str), start, end);
    }

    @Override
    public void replaceSelection(String content) {
        super.replaceSelection(this.replace(content));
    }

    @Override
    public String getText() {
        return this.replace(super.getText());
    }

    @Override
    public void setText(String t) {
        super.setText(this.replace(t));
    }

    private String replace(String string) {
        if (!this.allowNewline) {
            string = string.replaceAll("\\n", "").replaceAll("\\r", "");
        }
        if (!this.allowTab) {
            string = string.replaceAll("\\t", "").replaceAll("\\t", "");
        }
        return string;
    }
}

