/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.javamon.dev.utils.layout.AbstractPanel;

public class JScrollList
extends AbstractPanel {
    public static final int SINGLE = 0;
    public static final int SINGLE_INTERVAL = 1;
    public static final int MULTI_INTERVAL = 2;
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    private JList<String> list;
    private DefaultListModel<String> model;
    private String[] tooltips;
    private JScrollPane scrollPane;

    public JScrollList(int selectionMode, int wrapMode, int preferredWidth, int preferredHeight) {
        super(preferredWidth, preferredHeight);
        this.setList(selectionMode, wrapMode);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }

    @Override
    public void validate() {
    }

    public JList<String> list() {
        return this.list;
    }

    public DefaultListModel<String> model() {
        return this.model;
    }

    public void updateView(String[] tooltips, String ... entries) {
        this.tooltips = tooltips;
        this.model.removeAllElements();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.model.addElement(s);
            ++n2;
        }
        this.scrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width - this.borderWidth() - this.left() - this.right(), this.getPreferredSize().height - this.borderHeight() - this.top() - this.bottom()));
        this.scrollPane.setViewportView(this.list);
    }

    private void setList(int selectionMode, int wrapMode) {
        this.model = new DefaultListModel();
        this.list = new JList<String>(this.model){
            private static final long serialVersionUID = 7843413194965723770L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.locationToIndex(e.getPoint());
                if (JScrollList.this.tooltips == null || JScrollList.this.tooltips.length < row) {
                    return super.getToolTipText();
                }
                return JScrollList.this.tooltips[row];
            }
        };
        this.list.setSelectionMode(selectionMode);
        this.list.setLayoutOrientation(wrapMode);
        this.scrollPane = new JScrollPane(this.list);
        this.layoutFill(this.scrollPane, 0, this.panel, this.panel, this.panel, this.panel);
        this.add(this.scrollPane);
    }
}

