/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import net.javamon.dev.utils.HTML;

public class JLabelHTML
extends JLabel {
    private static final long serialVersionUID = 3921473327932844442L;
    private int width;
    private static JEditorPane dummyPane;

    public JLabelHTML(int width) {
        this.width = width;
        this.setVerticalAlignment(1);
    }

    public JLabelHTML(String text, int width) {
        super(text);
        this.width = width;
        this.setVerticalAlignment(1);
    }

    @Override
    public void setText(String text) {
        super.setText(HTML.wrap(text));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = super.getPreferredSize();
        Dimension actual = this.getSize();
        if (this.width > 0) {
            preferred.width = this.width;
        } else if (actual.width > 0) {
            preferred.width = actual.width;
        }
        preferred.height = JLabelHTML.getContentHeight(this, preferred.width);
        return preferred;
    }

    public void overrideLabelWidth(int width) {
        this.width = width;
    }

    public Rectangle2D getStringBounds(String text) {
        return this.getFontMetrics(this.getFont()).getStringBounds(text, this.getGraphics());
    }

    public void setWidth(int width) {
        this.setSize(new Dimension(width, this.getSize().height));
    }

    public void setHeight(int height) {
        this.setSize(new Dimension(this.getSize().width, height));
    }

    public void setPreferredWidth(int width) {
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
    }

    public void setPreferredHeight(int height) {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, height));
    }

    public void setMinimumWidth(int width) {
        this.setMinimumSize(new Dimension(width, this.getMinimumSize().height));
    }

    public void setMinimumHeight(int height) {
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, height));
    }

    public void setMaximumWidth(int width) {
        this.setMaximumSize(new Dimension(width, this.getMaximumSize().height));
    }

    public void setMaximumHeight(int height) {
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, height));
    }

    public String getTextNoTags() {
        return HTML.unwrap(this.getText());
    }

    private static int getContentHeight(JLabelHTML label, int width) {
        if (dummyPane == null) {
            dummyPane = new JEditorPane();
            dummyPane.setContentType("text/html");
            dummyPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            dummyPane.setBorder(null);
        }
        dummyPane.setFont(label.getFont());
        dummyPane.setSize(width, Short.MAX_VALUE);
        dummyPane.setText(String.valueOf(label.getTextNoTags()) + "<br>");
        return JLabelHTML.dummyPane.getPreferredSize().height;
    }
}

