/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class JAcceleratedPopupMenu {
    private JPopupMenu menu = new JPopupMenu();

    public boolean pressKey(KeyEvent e) {
        KeyStroke keystroke = KeyStroke.getKeyStrokeForEvent(e);
        ActionListener listener = this.menu.getActionForKeyStroke(keystroke);
        if (listener != null) {
            listener.actionPerformed(null);
            return true;
        }
        return false;
    }

    public void show(Component invoker, int x, int y) {
        this.menu.show(invoker, x, y);
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public void addMenuItem(final JMenuItem item) {
        KeyStroke accelerator = item.getAccelerator();
        if (accelerator != null) {
            String key = item.toString();
            this.menu.getInputMap(2).put(accelerator, key);
            this.menu.getActionMap().put(key, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    item.doClick();
                    JAcceleratedPopupMenu.this.menu.setVisible(false);
                }
            });
        }
        this.menu.add(item);
    }

    public void addMenu(JMenu menu, boolean inheritAccelerators) {
        if (inheritAccelerators) {
            this.addMenu(menu);
        }
        this.menu.add(menu);
    }

    private void addMenu(JMenu menu) {
        Component[] components = menu.getMenuComponents();
        int i = 0;
        while (i < components.length) {
            JMenuItem item;
            KeyStroke accelerator;
            if (components[i] instanceof JMenu) {
                this.addMenu((JMenu)components[i]);
            } else if (components[i] instanceof JMenuItem && (accelerator = (item = (JMenuItem)components[i]).getAccelerator()) != null) {
                String key = item.toString();
                this.menu.getInputMap(2).put(accelerator, key);
                this.menu.getActionMap().put(key, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        item.doClick();
                        JAcceleratedPopupMenu.this.menu.setVisible(false);
                    }
                });
            }
            ++i;
        }
    }
}

