/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.javamon.dev.AbstractFrame;

public class ButtonHideShow {
    private final JButton button;
    private final AbstractFrame hide;
    private final AbstractFrame show;
    private final Component hideComponent;
    private final Component showComponent;

    public ButtonHideShow(JButton button, AbstractFrame hide, AbstractFrame show) {
        this(button, hide, show, false, false);
    }

    public ButtonHideShow(JButton button, AbstractFrame hide, AbstractFrame show, boolean listenerHide) {
        this(button, hide, show, true, listenerHide);
    }

    public ButtonHideShow(JButton button, Component hideComponent, Component showComponent) {
        this(button, hideComponent, showComponent, false, false);
    }

    public ButtonHideShow(JButton button, Component hideComponent, Component showComponent, boolean listenerHide) {
        this(button, hideComponent, showComponent, true, listenerHide);
    }

    private ButtonHideShow(JButton button, AbstractFrame hide, AbstractFrame show, boolean listener, boolean listenerHide) {
        this(button, hide, show, null, null, listener, listenerHide);
    }

    private ButtonHideShow(JButton button, Component hideComponent, Component showComponent, boolean listener, boolean listenerHide) {
        this(button, null, null, hideComponent, showComponent, listener, listenerHide);
    }

    private ButtonHideShow(JButton button, AbstractFrame hide, AbstractFrame show, Component hideComponent, Component showComponent, boolean listener, final boolean listenerHide) {
        this.button = button;
        this.hide = hide;
        this.show = show;
        this.hideComponent = hideComponent;
        this.showComponent = showComponent;
        if (listener) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonHideShow.this.show(listenerHide);
                }
            });
        }
    }

    public JButton getButton() {
        return this.button;
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean hide) {
        if (this.showComponent != null || this.hideComponent != null) {
            if (this.hideComponent != null && hide) {
                this.hideComponent.setVisible(false);
            }
            if (this.showComponent != null) {
                this.showComponent.setVisible(true);
            }
        } else {
            if (this.hide != null && hide) {
                this.hide.hide();
            }
            if (this.show != null) {
                this.show.show();
            }
        }
    }
}

