/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipUtils {
    private static final byte[] BUFFER = new byte[8192];
    private static BufferedOutputStream output;

    private ZipUtils() {
        throw new AssertionError();
    }

    public static void extract(File input, File outputDir) throws Exception {
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(input));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (entry.isDirectory()) {
                ZipUtils.mkdirs(outputDir, name);
                entry = zipIn.getNextEntry();
                continue;
            }
            String dir = ZipUtils.getParentDir(name);
            if (dir != null) {
                ZipUtils.mkdirs(outputDir, dir);
            }
            ZipUtils.extractFile(zipIn, outputDir, name);
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    public static boolean invoke(File input, ZipInvokable invokable) throws Exception {
        invokable.start();
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(input));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (!entry.isDirectory() && invokable.invoke(zipIn, name)) {
                zipIn.close();
                return true;
            }
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        return false;
    }

    private static void extractFile(ZipInputStream zipIn, File outputDir, String name) throws Exception {
        ZipUtils.clearBuffer();
        output = new BufferedOutputStream(new FileOutputStream(new File(outputDir, name)));
        int count = zipIn.read(BUFFER);
        while (count != -1) {
            output.write(BUFFER, 0, count);
            count = zipIn.read(BUFFER);
        }
        output.close();
    }

    private static void clearBuffer() {
        int i = 0;
        while (i < BUFFER.length) {
            ZipUtils.BUFFER[i] = 0;
            ++i;
        }
    }

    private static void mkdirs(File outputDir, String path) {
        File f = new File(outputDir, path);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    private static String getParentDir(String name) {
        int index = name.lastIndexOf("\\");
        if (index == -1 && (index = name.lastIndexOf("/")) == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    public static interface ZipInvokable {
        public void start();

        public boolean invoke(ZipInputStream var1, String var2) throws Exception;
    }
}

