/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import net.javamon.dev.Resources;

public final class StringUtils {
    private StringUtils() {
        throw new AssertionError();
    }

    public static String getFormattedBytes(long toConvert) {
        double bytes = toConvert;
        double kb = bytes / 1024.0;
        double mb = bytes / 1048576.0;
        double gb = bytes / 1.073741824E9;
        if (gb >= 1.0) {
            return Resources.__("mainSizeGB", Float.valueOf((float)gb));
        }
        if (mb >= 1.0) {
            return Resources.__("mainSizeMB", Float.valueOf((float)mb));
        }
        if (kb >= 1.0) {
            return Resources.__("mainSizeKB", Float.valueOf((float)kb));
        }
        return Resources.__("mainSizeBytes", (int)bytes);
    }

    public static String longestCommonPrefix(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int commonPrefix = 0;
        while (StringUtils.matches(strings, commonPrefix)) {
            ++commonPrefix;
        }
        return strings[0].substring(0, commonPrefix);
    }

    private static boolean matches(String[] strings, int position) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() <= position || s.charAt(position) != strings[0].charAt(position)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

