/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SetUtils {
    private SetUtils() {
        throw new AssertionError();
    }

    @SafeVarargs
    public static <T> HashSet<T> union(Set<T> ... sets) {
        return SetUtils.union(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <T> HashSet<T> intersect(Set<T> ... sets) {
        return SetUtils.intersect(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <T> HashSet<T> nonIntersect(Set<T> ... sets) {
        return SetUtils.nonIntersect(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <T> HashSet<T> symmetricDifference(Set<T> ... sets) {
        return SetUtils.symmetricDifference(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <T> HashSet<T> asymmetricDifference(Set<T> ... sets) {
        return SetUtils.asymmetricDifference(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <T> HashSet<T> totalIntersect(Set<T> ... sets) {
        return SetUtils.totalIntersect(Arrays.asList(sets));
    }

    @SafeVarargs
    public static <T> HashSet<T> totalDifference(Set<T> ... sets) {
        return SetUtils.totalDifference(Arrays.asList(sets));
    }

    private static <T> HashSet<T> union(List<Set<T>> sets) {
        HashSet<T> union = new HashSet<T>();
        for (Set<T> set : sets) {
            for (T item : set) {
                union.add(item);
            }
        }
        return union;
    }

    private static <T> HashSet<T> intersect(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = SetUtils.getOccurrences(sets);
        HashSet<T> intersect = new HashSet<T>();
        Set<T> keySet = occurrences.keySet();
        for (T item : keySet) {
            if (occurrences.get(item).intValue() != sets.size()) continue;
            intersect.add(item);
        }
        return intersect;
    }

    private static <T> HashSet<T> nonIntersect(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = SetUtils.getOccurrences(sets);
        HashSet<T> nonIntersect = new HashSet<T>();
        Set<T> keySet = occurrences.keySet();
        for (T item : keySet) {
            if (occurrences.get(item) >= sets.size()) continue;
            nonIntersect.add(item);
        }
        return nonIntersect;
    }

    private static <T> HashSet<T> symmetricDifference(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = SetUtils.getOccurrences(sets);
        HashSet<T> symmetricDifference = new HashSet<T>();
        Set<T> keySet = occurrences.keySet();
        for (T item : keySet) {
            if (occurrences.get(item) % 2 != 1) continue;
            symmetricDifference.add(item);
        }
        return symmetricDifference;
    }

    private static <T> HashSet<T> asymmetricDifference(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = SetUtils.getOccurrences(sets);
        HashSet<T> symmetricDifference = new HashSet<T>();
        Set<T> keySet = occurrences.keySet();
        for (T item : keySet) {
            if (occurrences.get(item) % 2 != 0) continue;
            symmetricDifference.add(item);
        }
        return symmetricDifference;
    }

    private static <T> HashSet<T> totalIntersect(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = SetUtils.getOccurrences(sets);
        HashSet<T> totalIntersect = new HashSet<T>();
        Set<T> keySet = occurrences.keySet();
        for (T item : keySet) {
            if (occurrences.get(item) <= 1) continue;
            totalIntersect.add(item);
        }
        return totalIntersect;
    }

    private static <T> HashSet<T> totalDifference(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = SetUtils.getOccurrences(sets);
        HashSet<T> totalDifference = new HashSet<T>();
        Set<T> keySet = occurrences.keySet();
        for (T item : keySet) {
            if (occurrences.get(item) != 1) continue;
            totalDifference.add(item);
        }
        return totalDifference;
    }

    private static <T> HashMap<T, Integer> getOccurrences(List<Set<T>> sets) {
        HashMap<T, Integer> occurrences = new HashMap<T, Integer>();
        for (Set<T> set : sets) {
            for (T item : set) {
                if (occurrences.containsKey(item)) {
                    occurrences.put(item, (Integer)occurrences.get(item) + 1);
                    continue;
                }
                occurrences.put(item, 1);
            }
        }
        return occurrences;
    }
}

