/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.File;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.javamon.dev.BinaryFile;
import net.javamon.dev.Dictionaries;
import net.javamon.dev.Ext;
import net.javamon.dev.Prompt;
import net.javamon.dev.PropertiesFile;

public final class Resources {
    public static final String APP = "/app/";
    public static final String APP_SETTINGS = "/app/settings.cfg";
    public static final String APP_IMAGES = "/app/images/";
    public static final String APP_LANG = "/app/lang/";
    private static final String NO_SETTINGS_HEADER = "Missing Settings File";
    private static final String NO_SETTINGS_MESSAGE = "<html>This application's primary settings file is missing or could not be read.<br><br>The application will now close.</html>";
    private static final String NO_LANG_HEADER = "Missing Language File";
    private static final String NO_LANG_MESSAGE = "<html>This application's primary language file is missing or could not be read.<br><br>The application will now close.</html>";
    private static boolean initialized = false;
    private static File appDir;
    private static PropertiesFile settings;
    private static PropertiesFile userSettings;
    private static PropertiesFile editorText;
    private static PropertiesFile fallbackText;
    private static Dictionaries dictionaries;
    private static File mainDir;
    private static File extDir;

    private Resources() {
        throw new AssertionError();
    }

    public static boolean init(String dir, String appName) {
        ToolTipManager.sharedInstance().setDismissDelay(8000);
        ToolTipManager.sharedInstance().setInitialDelay(500);
        ToolTipManager.sharedInstance().setReshowDelay(1000);
        if (appDir == null) {
            appDir = new File(dir);
            String main = String.valueOf(dir) + APP_SETTINGS;
            settings = new PropertiesFile(main, true, true, false, false, 0, 0);
            if (settings.isError()) {
                Prompt.error(NO_SETTINGS_HEADER, NO_SETTINGS_MESSAGE);
                return false;
            }
            String homeDir = System.getProperty("user.home");
            if (homeDir != null && appName != null && (userSettings = new PropertiesFile(new File(homeDir, "temp/app/" + appName + ".cfg").getAbsolutePath(), false, true, true, false, 0, 0)).isError()) {
                userSettings = null;
            }
            String editorLang = settings.get("editorLang");
            editorText = new PropertiesFile(String.valueOf(dir) + APP_LANG + editorLang + ".cfg", true, false, false, false, 0, 0);
            if (editorText.isError()) {
                Prompt.error(NO_LANG_HEADER, NO_LANG_MESSAGE);
                return false;
            }
            String fallbackLang = settings.get("fallbackLang");
            if (fallbackLang != null && !fallbackLang.equals(editorLang) && (fallbackText = new PropertiesFile(String.valueOf(dir) + APP_LANG + fallbackLang + ".cfg", true, false, false, false, 0, 0)).isError()) {
                fallbackText = null;
            }
            String lastDirMain = settings.get("lastDirMain");
            String lastDirExt = settings.get("lastDirExternal");
            if (lastDirMain != null && lastDirExt != null) {
                Resources.setMainDirectory(new File(lastDirMain));
                Resources.setExternalDirectory(new File(lastDirExt));
            }
        }
        initialized = true;
        return true;
    }

    public static boolean initialized() {
        return initialized;
    }

    public static Dictionaries dictionaries() {
        return dictionaries;
    }

    public static String __(String key, Object ... args) {
        if (key == null) {
            return null;
        }
        if (key.length() == 0) {
            return key;
        }
        String toFormat = editorText.get(key);
        if (toFormat == null && fallbackText != null) {
            toFormat = fallbackText.get(key);
        }
        if (toFormat == null) {
            System.err.println("Key '" + key + "' could not be found in the string table");
            Thread.dumpStack();
            return "";
        }
        return String.format(toFormat, args);
    }

    public static File getAppImage(String imageName) {
        return new File(appDir + APP_IMAGES + imageName + ".png");
    }

    public static File getAppFile(String fileName) {
        return new File(appDir + APP + "/" + fileName);
    }

    public static String readSetting(String setting) {
        return settings.get(setting);
    }

    public static void writeSetting(String setting, String value) {
        settings.add(setting, value);
        settings.save();
    }

    public static String readUserSetting(String setting) {
        return userSettings == null ? null : userSettings.get(setting);
    }

    public static void writeUserSetting(String setting, String value) {
        if (userSettings != null) {
            userSettings.add(setting, value);
            userSettings.save();
        }
    }

    public static void removeUserSetting(String setting) {
        if (userSettings != null) {
            userSettings.remove(setting);
            userSettings.save();
        }
    }

    public static File getRelativePath(String relativePath) {
        return new File(String.valueOf(mainDir.getAbsolutePath()) + "/" + relativePath);
    }

    public static String trimFullPath(String fullPath) {
        if (fullPath.startsWith(mainDir.getAbsolutePath())) {
            return fullPath.substring(mainDir.getAbsolutePath().length() + 1);
        }
        if (fullPath.startsWith(extDir.getAbsolutePath())) {
            return fullPath.substring(extDir.getAbsolutePath().length() + 1);
        }
        return fullPath;
    }

    public static FileNameExtensionFilter fileType(String extension) {
        String raw = Ext.noDot(extension);
        return new FileNameExtensionFilter(Resources.__("appFileFilter", raw.toUpperCase(), Ext.wild(extension)), raw);
    }

    public static BinaryFile getBinary(String path, int offsetSize, boolean external, boolean allowWrite) {
        BinaryFile toReturn = Resources.getBinaryNoMessage(path, offsetSize, external, allowWrite, true, false);
        if (toReturn == null) {
            Resources.notFound(path, external);
        }
        return toReturn;
    }

    public static BinaryFile getBinary(String path, String editorKey, boolean external, boolean allowWrite) {
        BinaryFile toReturn = Resources.getBinaryNoMessage(path, 0, external, allowWrite, false, false);
        if (toReturn == null) {
            Resources.useEditor(path, Resources.__(editorKey, new Object[0]), external);
        }
        return toReturn;
    }

    public static PropertiesFile getProps(String path, boolean errorIfEmpty, boolean external, boolean allowWrite, int type, int wrap) {
        PropertiesFile toReturn = Resources.getPropsNoMessage(path, errorIfEmpty, external, allowWrite, false, false, type, wrap);
        if (toReturn == null) {
            if (errorIfEmpty) {
                Resources.empty(path, external);
            } else {
                Resources.notFound(path, external);
            }
        }
        return toReturn;
    }

    public static PropertiesFile getProps(String path, boolean errorIfEmpty, String editorKey, boolean external, boolean allowWrite, int type, int wrap) {
        PropertiesFile toReturn = Resources.getPropsNoMessage(path, errorIfEmpty, external, allowWrite, false, false, type, wrap);
        if (toReturn == null) {
            Resources.useEditor(path, Resources.__(editorKey, new Object[0]), external);
        }
        return toReturn;
    }

    public static PropertiesFile getProps(String path, String startKey, String startValue, boolean external, boolean create, int type, int wrap) {
        PropertiesFile toReturn = Resources.getPropsNoMessage(path, false, external, true, create, false, type, wrap);
        if (toReturn == null) {
            Resources.empty(path, external);
        } else if (toReturn.size() == 0) {
            toReturn.add(startKey, startValue);
        }
        return toReturn;
    }

    public static BinaryFile getBinaryNoMessage(String path, int offsetSize, boolean external, boolean allowWrite, boolean create, boolean errorIfExists) {
        BinaryFile toReturn = new BinaryFile(String.valueOf(Resources.resolvePath(external)) + path, offsetSize, allowWrite, create, errorIfExists);
        if (toReturn.isError()) {
            return null;
        }
        return toReturn;
    }

    public static PropertiesFile getPropsNoMessage(String path, boolean errorIfEmpty, boolean external, boolean allowWrite, boolean create, boolean errorIfExists, int type, int wrap) {
        PropertiesFile toReturn = new PropertiesFile(String.valueOf(Resources.resolvePath(external)) + path, errorIfEmpty, allowWrite, create, errorIfExists, type, wrap);
        if (toReturn.isError()) {
            return null;
        }
        return toReturn;
    }

    public static void notFound(String path, boolean external) {
        Prompt.error(Resources.__("appErrorLoadH", new Object[0]), Resources.__("appNotFoundMsg", String.valueOf(Resources.resolvePath(external)) + path));
    }

    public static void empty(String path, boolean external) {
        Prompt.error(Resources.__("appErrorLoadH", new Object[0]), Resources.__("appEmptyMsg", String.valueOf(Resources.resolvePath(external)) + path));
    }

    public static void useEditor(String path, String use, boolean external) {
        Prompt.error(Resources.__("appErrorLoadH", new Object[0]), Resources.__("appUseEditorMsg", String.valueOf(Resources.resolvePath(external)) + path, use));
    }

    public static void notCreated(String path, boolean external) {
        Prompt.error(Resources.__("appErrorCreateH", new Object[0]), Resources.__("appNotCreatedMsg", String.valueOf(Resources.resolvePath(external)) + path));
    }

    public static void setMainDirectory(File mainDir) {
        Resources.mainDir = mainDir;
        try {
            settings.add("lastDirMain", mainDir.getAbsolutePath().replaceAll("\\\\", "/"));
            settings.save();
        }
        catch (Exception e) {
            settings.remove("lastDirMain");
            settings.save();
        }
        if (dictionaries == null) {
            dictionaries = new Dictionaries();
        }
    }

    public static void setExternalDirectory(File extDir) {
        Resources.extDir = extDir;
        settings.add("lastDirExt", extDir.getAbsolutePath().replaceAll("\\\\", "/"));
        settings.save();
    }

    private static String resolvePath(boolean external) {
        if (external) {
            return String.valueOf(extDir.getAbsolutePath()) + "/";
        }
        return String.valueOf(mainDir.getAbsolutePath()) + "/";
    }
}

