/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public final class ReaderTools {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ReaderTools() {
        throw new AssertionError();
    }

    public static String toHex(byte[] input) {
        char[] buf = new char[input.length * 2];
        int i = 0;
        int x = 0;
        while (i < input.length) {
            buf[x++] = HEX_CHARS[input[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[input[i] & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public static ArrayList<String> readAllLines(File input, boolean noTrailing) throws Exception {
        return ReaderTools.readAllLines(input, noTrailing, new ArrayList<String>());
    }

    public static ArrayList<String> readAllLines(File input, boolean noTrailing, ArrayList<String> lines) throws Exception {
        lines.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        String next = reader.readLine();
        while (next != null) {
            lines.add(next);
            next = reader.readLine();
        }
        if (noTrailing) {
            int i = lines.size() - 1;
            while (i >= 0) {
                if (lines.get(i).length() != 0) break;
                lines.remove(i);
                --i;
            }
        }
        reader.close();
        return lines;
    }
}

