/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.javamon.dev.EscapedProperties;
import net.javamon.dev.NaturalOrder;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.WordWrap;

public class PropertiesFile {
    public static final int UNORDERED = 0;
    public static final int ORDERED_KEY = 1;
    public static final int ORDERED_VALUE = 2;
    private File location;
    private EscapedProperties properties;
    private boolean allowWrite;
    private boolean isError;
    private int type;
    private int wrap;

    protected PropertiesFile(String fullPath, boolean errorIfEmpty, boolean allowWrite, boolean create, boolean errorIfExists, int type, int wrap) {
        this.allowWrite = allowWrite;
        this.type = type;
        this.wrap = wrap;
        this.isError = false;
        this.location = new File(fullPath);
        if (!this.location.exists() && (!create || errorIfEmpty || !allowWrite) || this.location.exists() && errorIfExists) {
            this.error();
            return;
        }
        this.properties = new EscapedProperties();
        try {
            if (!this.location.exists() && create) {
                this.location.getParentFile().mkdirs();
                this.location.createNewFile();
            }
            FileInputStream inputStream = new FileInputStream(this.location);
            this.properties.load(inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            this.error();
            return;
        }
        if (errorIfEmpty && this.properties.size() == 0) {
            this.error();
            return;
        }
    }

    public boolean isError() {
        return this.isError;
    }

    public int size() {
        if (this.isError) {
            return 0;
        }
        return this.properties.size();
    }

    public boolean delete() {
        if (this.isError) {
            return false;
        }
        if (this.location.delete()) {
            this.error();
            return true;
        }
        return false;
    }

    public boolean rename(String newName) {
        if (this.isError) {
            return false;
        }
        String ext = "";
        int indexExt = this.location.getName().lastIndexOf(".");
        if (indexExt != -1) {
            ext = this.location.getName().substring(indexExt);
        }
        String oldLocation = this.location.getAbsolutePath();
        Path source = Paths.get(this.location.getAbsolutePath(), new String[0]);
        Path newPath = source.resolveSibling(String.valueOf(newName) + ext);
        try {
            Files.move(source, newPath, new CopyOption[0]);
            this.location = newPath.toFile();
        }
        catch (Exception e) {
            Prompt.error(Resources.__("appErrorRenameH", new Object[0]), Resources.__("appErrorRenameMsg", oldLocation, newPath.toString()));
            return false;
        }
        return true;
    }

    public void close(boolean save) {
        if (save) {
            this.save();
        }
        this.error();
    }

    public void add(String key, String value) {
        if (this.isError || key == null || !this.allowWrite) {
            return;
        }
        this.properties.setProperty(key, value);
    }

    public String get(String key) {
        if (this.isError || key == null) {
            return null;
        }
        return WordWrap.unwrap(this.properties.getProperty(key), this.wrap);
    }

    public void remove(String key) {
        if (this.isError || key == null || !this.allowWrite) {
            return;
        }
        this.properties.remove(key);
    }

    public void removeValue(String value) {
        if (this.isError || value == null || !this.allowWrite) {
            return;
        }
        String key = this.find(value);
        if (key != null) {
            this.properties.remove(key);
        }
    }

    public void removeShift(int key) {
        this.removeShift(key, true);
    }

    public void removeShiftValue(int value) {
        this.removeShift(value, false);
    }

    public String find(String value) {
        if (this.isError || value == null) {
            return null;
        }
        ArrayList<Map.Entry<Object, Object>> list = this.getSorted();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getValue() != null && list.get(i).getValue().equals(value)) {
                return (String)list.get(i).getKey();
            }
            ++i;
        }
        return null;
    }

    public void replace(String oldKey, String newKey) {
        if (this.isError || oldKey == null || newKey == null || !this.allowWrite) {
            return;
        }
        String oldValue = this.properties.getProperty(oldKey);
        if (oldValue != null) {
            this.properties.remove(oldKey);
            this.properties.setProperty(newKey, oldValue);
        }
    }

    public String[] getKeys(boolean prependIndices, boolean numericOnly) {
        return this.getEntries(prependIndices, true, numericOnly);
    }

    public String[] getKeysRange(boolean prependIndices, String prefix, String suffix, int start, int end) {
        return this.getEntriesByRange(prependIndices, true, prefix, suffix, start, end);
    }

    public String[] getValues(boolean prependIndices, boolean numericOnly) {
        return this.getEntries(prependIndices, false, numericOnly);
    }

    public String[] getValuesRange(boolean prependIndices, String prefix, String suffix, int start, int end) {
        return this.getEntriesByRange(prependIndices, false, prefix, suffix, start, end);
    }

    protected void save() {
        this.save(this.getSorted());
    }

    private void error() {
        this.location = null;
        this.properties = null;
        this.isError = true;
    }

    private ArrayList<Map.Entry<Object, Object>> getSorted() {
        Set<Map.Entry<Object, Object>> entries = this.properties.entrySet();
        ArrayList<Map.Entry<Object, Object>> list = new ArrayList<Map.Entry<Object, Object>>(entries);
        NaturalOrder.ObjectComparator comparator = new NaturalOrder.ObjectComparator();
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                list.sort(Map.Entry.comparingByKey(comparator));
                break;
            }
            case 2: {
                list.sort(Map.Entry.comparingByValue(comparator));
            }
        }
        return list;
    }

    private void save(ArrayList<Map.Entry<Object, Object>> list) {
        if (this.isError || !this.allowWrite) {
            return;
        }
        try {
            BufferedWriter stream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.location), "UTF-8"));
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).getValue() != null) {
                    String toWrite = list.get(i).getKey() + "=" + list.get(i).getValue().toString().replace("\\", "\\\\");
                    stream.write(String.valueOf(WordWrap.wrap(toWrite, this.wrap)) + "\n");
                }
                ++i;
            }
            stream.close();
        }
        catch (IOException e) {
            Prompt.error(Resources.__("appSaveErrorH", new Object[0]), Resources.__("appSaveErrorMsg", this.location.getAbsolutePath()));
        }
    }

    private String[] getEntriesByRange(boolean prependIndices, boolean keys, String prefix, String suffix, int start, int end) {
        if (this.isError) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        String next = null;
        int prependIndex = 0;
        int currIndex = start;
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        do {
            if ((next = keys ? this.find(String.valueOf(prefix) + currIndex + suffix) : this.get(String.valueOf(prefix) + currIndex + suffix)) == null) continue;
            if (prependIndices) {
                entries.add(Resources.__("appStringIndex", prependIndex, next));
            } else {
                entries.add(next);
            }
            ++prependIndex;
            ++currIndex;
        } while (next != null && (end <= currIndex || currIndex < end));
        if (entries.size() == 0) {
            return null;
        }
        String[] toReturn = new String[entries.size()];
        entries.toArray(toReturn);
        return toReturn;
    }

    private String[] getEntries(boolean prependIndices, boolean keys, boolean numericOnly) {
        if (this.isError) {
            return null;
        }
        ArrayList<Map.Entry<Object, Object>> list = this.getSorted();
        String[] toReturn = new String[list.size()];
        int length = 0;
        int i = 0;
        while (i < list.size()) {
            block9: {
                if (list.get(i).getValue() != null) {
                    String toPut = (String)list.get(i).getKey();
                    String toParse = (String)list.get(i).getValue();
                    if (!keys) {
                        toParse = toPut;
                        toPut = (String)list.get(i).getValue();
                    }
                    if (numericOnly) {
                        try {
                            Integer.parseInt(toParse);
                        }
                        catch (NumberFormatException e) {
                            break block9;
                        }
                    }
                    toReturn[length] = toPut;
                    if (prependIndices) {
                        toReturn[length] = Resources.__("appStringIndex", length, toReturn[length]);
                    }
                    ++length;
                }
            }
            ++i;
        }
        if (length == toReturn.length) {
            return toReturn;
        }
        String[] trimmed = new String[length];
        System.arraycopy(toReturn, 0, trimmed, 0, length);
        return trimmed;
    }

    private void removeShift(int remove, boolean key) {
        if (this.isError || !this.allowWrite) {
            return;
        }
        ArrayList<Map.Entry<Object, Object>> list = this.getSorted();
        ArrayList<String> modKeys = new ArrayList<String>();
        ArrayList<String> modValues = new ArrayList<String>();
        int toRemove = -1;
        int i = 0;
        while (i < list.size()) {
            block10: {
                if (list.get(i).getValue() != null) {
                    if (toRemove != -1) {
                        try {
                            if (key) {
                                modKeys.add(String.valueOf(Integer.parseInt((String)list.get(i).getKey()) - 1));
                                modValues.add((String)list.get(i).getValue());
                                break block10;
                            }
                            modValues.add(String.valueOf(Integer.parseInt((String)list.get(i).getValue()) - 1));
                            modKeys.add((String)list.get(i).getKey());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (key && list.get(i).getKey().equals(String.valueOf(remove)) || !key && list.get(i).getValue().equals(String.valueOf(remove))) {
                        toRemove = i;
                    }
                }
            }
            ++i;
        }
        this.properties.remove(list.get(toRemove).getKey());
        this.properties.remove(list.get(list.size() - 1).getKey());
        i = 0;
        while (i < modKeys.size()) {
            this.properties.setProperty((String)modKeys.get(i), (String)modValues.get(i));
            ++i;
        }
    }
}

