/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import net.javamon.dev.utils.JLabelHTML;

public final class Prompt {
    private static final int MESSAGE_WIDTH = 450;
    private static final int MESSAGE_HEIGHT = 250;
    private static Component messageComponent;
    private static JTextPane textArea;
    private static JScrollPane scrollPane;
    private static JLabelHTML label;

    private Prompt() {
        throw new AssertionError();
    }

    public static void setMessageComponent(Component c) {
        messageComponent = c;
    }

    public static void messageScroll(String title, String message) {
        Prompt.message(messageComponent, title, Prompt.wrap(message, true));
    }

    public static void message(String title, String message) {
        Prompt.message(messageComponent, title, Prompt.wrap(message, false));
    }

    public static void warningScroll(String title, String message) {
        Prompt.warning(messageComponent, title, Prompt.wrap(message, true));
    }

    public static void warning(String title, String message) {
        Prompt.warning(messageComponent, title, Prompt.wrap(message, false));
    }

    public static void errorScroll(String title, String message) {
        Prompt.error(messageComponent, title, Prompt.wrap(message, true));
    }

    public static void error(String title, String message) {
        Prompt.error(messageComponent, title, Prompt.wrap(message, false));
    }

    public static int showScroll(String title, String message) {
        return Prompt.show(messageComponent, title, Prompt.wrap(message, true));
    }

    public static int show(String title, String message) {
        return Prompt.show(messageComponent, title, Prompt.wrap(message, false));
    }

    public static int showCancelScroll(String title, String message) {
        return Prompt.showCancel(messageComponent, title, Prompt.wrap(message, true));
    }

    public static int showCancel(String title, String message) {
        return Prompt.showCancel(messageComponent, title, Prompt.wrap(message, false));
    }

    public static String inputScroll(String title, String message) {
        return Prompt.input(messageComponent, title, Prompt.wrap(message, true));
    }

    public static String input(String title, String message) {
        return Prompt.input(messageComponent, title, Prompt.wrap(message, false));
    }

    public static String inputDefaultScroll(String title, String message, String value) {
        return Prompt.inputDefault(messageComponent, title, Prompt.wrap(message, true), value);
    }

    public static String inputDefault(String title, String message, String value) {
        return Prompt.inputDefault(messageComponent, title, Prompt.wrap(message, false), value);
    }

    private static void message(Component c, String title, Object message) {
        JOptionPane.showMessageDialog(c, message, title, 1);
    }

    private static void warning(Component c, String title, Object message) {
        JOptionPane.showMessageDialog(c, message, title, 2);
    }

    private static void error(Component c, String title, Object message) {
        JOptionPane.showMessageDialog(c, message, title, 0);
    }

    private static int show(Component c, String title, Object message) {
        return JOptionPane.showConfirmDialog(c, message, title, 0);
    }

    private static int showCancel(Component c, String title, Object message) {
        return JOptionPane.showConfirmDialog(c, message, title, 1);
    }

    private static String input(Component c, String title, Object message) {
        return JOptionPane.showInputDialog(c, message, title, 3);
    }

    private static String inputDefault(Component c, String title, Object message, String value) {
        return (String)JOptionPane.showInputDialog(c, message, title, 3, null, null, value);
    }

    private static Object wrap(String message, boolean scroll) {
        if (scroll) {
            return Prompt.wrapPane(message);
        }
        return Prompt.wrapLabel(message);
    }

    private static JScrollPane wrapPane(String message) {
        if (textArea == null) {
            textArea = new JTextPane();
            textArea.setContentType("text/html");
            textArea.putClientProperty("JEditorPane.honorDisplayProperties", true);
            textArea.setFont(new JLabel().getFont());
            textArea.setOpaque(false);
            textArea.setBorder(null);
            textArea.setMargin(new Insets(5, 5, 5, 5));
            textArea.setEditable(false);
        }
        textArea.setText(message);
        if (scrollPane == null) {
            scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(450, 250));
            scrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        }
        textArea.setCaretPosition(0);
        scrollPane.getViewport().setView(textArea);
        return scrollPane;
    }

    private static Object wrapLabel(String message) {
        View view;
        int minWidth;
        if (label == null) {
            label = new JLabelHTML(450);
        }
        label.overrideLabelWidth((minWidth = (int)(view = BasicHTML.createHTMLView(label, message)).getMinimumSpan(0)) > 450 ? minWidth : 450);
        label.setText(message);
        return label;
    }
}

