/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.IOException;
import java.util.StringTokenizer;

public final class ProcessHelper {
    private static final String CMD_PREFIX = "cmd /c start /wait ";
    private static Process process;

    private ProcessHelper() {
        throw new AssertionError();
    }

    public static String cmd(String defaultErrorMessage, String command) {
        return ProcessHelper.run(defaultErrorMessage, CMD_PREFIX + command);
    }

    public static String run(String defaultErrorMessage, String command) {
        if (defaultErrorMessage == null) {
            defaultErrorMessage = "";
        }
        int returnCode = ProcessHelper.run(command, true);
        try {
            if (returnCode != 0 && process.getErrorStream().available() > 0) {
                byte[] buffer = new byte[process.getErrorStream().available()];
                process.getErrorStream().read(buffer);
                process.destroy();
                return new String(buffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return returnCode == 0 ? null : defaultErrorMessage;
    }

    public static void dispatch(String command) {
        ProcessHelper.run(command, false);
    }

    private static int run(String command, boolean wait) {
        StringTokenizer commandTokenizer = new StringTokenizer(command);
        String[] commands = new String[commandTokenizer.countTokens()];
        int i = 0;
        while (commandTokenizer.hasMoreTokens()) {
            commands[i] = commandTokenizer.nextToken();
            ++i;
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(commands).directory(null);
            process = builder.start();
            if (wait) {
                return process.waitFor();
            }
        }
        catch (Exception e) {
            return 1;
        }
        return 0;
    }
}

