/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.File;
import java.util.Comparator;

public final class NaturalOrder {
    private NaturalOrder() {
        throw new AssertionError();
    }

    public static int compare(String o1, String o2) {
        String s1 = o1;
        String s2 = o2;
        if (s1.isEmpty() && s2.isEmpty()) {
            return 0;
        }
        if (s1.isEmpty()) {
            return -1;
        }
        if (s2.isEmpty()) {
            return 1;
        }
        char c1 = s1.charAt(0);
        char c2 = s2.charAt(0);
        boolean b1 = Character.isDigit(c1);
        boolean b2 = Character.isDigit(c2);
        if (b1 && !b2 || !b1 && b2) {
            return s1.compareTo(s2);
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int pos1 = 0;
        int pos2 = 0;
        boolean bIsDigit = b1;
        while (true) {
            if (bIsDigit) {
                long n1 = 0L;
                long n2 = 0L;
                do {
                    if (!(b1 = Character.isDigit(c1 = s1.charAt(pos1)))) continue;
                    n1 = n1 * 10L + (long)(c1 - 48);
                } while (b1 && ++pos1 < len1);
                do {
                    if (!(b2 = Character.isDigit(c2 = s2.charAt(pos2)))) continue;
                    n2 = n2 * 10L + (long)(c2 - 48);
                } while (b2 && ++pos2 < len2);
                if (n1 < n2) {
                    return -1;
                }
                if (n1 > n2) {
                    return 1;
                }
                if (pos1 == len1 && pos2 == len2) {
                    return 0;
                }
            } else {
                do {
                    c1 = s1.charAt(pos1);
                    c2 = s2.charAt(pos2);
                    b1 = !Character.isDigit(c1);
                    boolean bl = b2 = !Character.isDigit(c2);
                    if (b1 && b2 && c1 != c2) {
                        return c1 - c2;
                    }
                    if ((!b1 || b2) && (b1 || !b2)) continue;
                    return c1 - c2;
                } while (b1 && b2 && ++pos1 < len1 && ++pos2 < len2);
                if (b1 && pos1 == len1 && pos2 == len2) {
                    return 0;
                }
            }
            if (pos1 == len1 && len1 < len2) {
                return -1;
            }
            if (pos2 == len2 && len2 < len1) {
                return 1;
            }
            if (!bIsDigit) {
                --pos1;
                --pos2;
            }
            bIsDigit = !bIsDigit;
        }
    }

    public static class FileNameComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            return NaturalOrder.compare(o1.getName(), o2.getName());
        }
    }

    public static class FilePathComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            return NaturalOrder.compare(o1.getAbsolutePath(), o2.getAbsolutePath());
        }
    }

    public static class ObjectComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            return NaturalOrder.compare(o1.toString(), o2.toString());
        }
    }

    public static class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return NaturalOrder.compare(o1, o2);
        }
    }
}

