/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.Point;
import java.awt.image.BufferedImage;

public final class ImageTools {
    private ImageTools() {
        throw new AssertionError();
    }

    public static boolean isEqual(BufferedImage image1, BufferedImage image2) {
        int width1 = image1.getWidth();
        int width2 = image2.getWidth();
        int height1 = image1.getHeight();
        int height2 = image2.getHeight();
        if (width1 != width2 || height1 != height2) {
            return false;
        }
        int x = 0;
        while (x < width1) {
            int y = 0;
            while (y < height1) {
                if (image1.getRGB(x, y) != image2.getRGB(x, y)) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public static boolean findInImage(BufferedImage[] toFind, BufferedImage toSearch, Point result, boolean requireAll) {
        int i = 0;
        while (i < toFind.length) {
            if (!requireAll && ImageTools.findInImage(toFind[i], toSearch, result)) {
                return true;
            }
            if (requireAll && !ImageTools.findInImage(toFind[i], toSearch, result)) {
                return false;
            }
            ++i;
        }
        return requireAll;
    }

    public static boolean findInImage(BufferedImage toFind, BufferedImage toSearch, Point result) {
        int findWidth = toFind.getWidth();
        int findHeight = toFind.getHeight();
        int searchWidth = toSearch.getWidth();
        int searchHeight = toSearch.getHeight();
        if (result != null) {
            result.x = -1;
            result.y = -1;
        }
        if (findWidth > searchWidth || findHeight > searchHeight) {
            return false;
        }
        int y = 0;
        while (y < searchHeight) {
            int x = 0;
            while (x < searchWidth) {
                BufferedImage subimage;
                if (x + findWidth < searchWidth && y + findHeight < searchHeight && ImageTools.isEqual(toFind, subimage = toSearch.getSubimage(x, y, findWidth, findHeight))) {
                    if (result != null) {
                        result.x = x + findWidth / 2;
                        result.y = y + findHeight / 2;
                    }
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }
}

