/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;

public final class ImageCache {
    private static HashMap<String, BufferedImageData> images = new HashMap();

    private ImageCache() {
        throw new AssertionError();
    }

    public static BufferedImageData request(File file) {
        BufferedImageData toReturn = ImageCache.get(file);
        if (toReturn == null) {
            Prompt.error(Resources.__("appMissingImageH", new Object[0]), Resources.__("appMissingImageMsg", file.getAbsolutePath()));
        }
        return toReturn;
    }

    public static BufferedImageData get(File file) {
        String key = file.getAbsolutePath();
        BufferedImageData toReturn = images.get(key);
        try {
            if (toReturn == null) {
                toReturn = new BufferedImageData(file);
                images.put(key, toReturn);
            } else {
                toReturn.update(file);
            }
            return toReturn;
        }
        catch (IOException e) {
            System.err.println("could not load image file '" + file.getAbsolutePath() + "'");
            return null;
        }
    }

    public static boolean dispose(File file) {
        return images.remove(file.getAbsolutePath()) != null;
    }

    public static boolean dispose(BufferedImageData imageData) {
        return images.remove(imageData.file.getAbsolutePath()) != null;
    }

    public static class BufferedImageData {
        private File file;
        private BufferedImage image;
        private long lastModified;

        protected BufferedImageData(File file) throws IOException {
            this.update(file);
        }

        public BufferedImage get() {
            return this.image;
        }

        private void update(File file) throws IOException {
            if (this.lastModified == 0L || file.lastModified() > this.lastModified) {
                this.file = file;
                this.image = ImageIO.read(file);
                this.lastModified = file.lastModified();
            }
        }
    }
}

