/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.File;
import net.javamon.dev.ProcessHelper;

public final class FileUtils {
    private FileUtils() {
        throw new AssertionError();
    }

    public static boolean isRemote(File file) {
        String filePath = file.getAbsolutePath();
        if (System.getProperty("os.name") == null || !System.getProperty("os.name").contains("Windows")) {
            return false;
        }
        if (filePath.startsWith("//") || filePath.startsWith("\\\\")) {
            return true;
        }
        if (filePath.length() < 3 || !String.valueOf(filePath.charAt(0)).matches("[A-Z]") || filePath.charAt(1) != ':' || filePath.charAt(2) != '\\') {
            return false;
        }
        return ProcessHelper.run("error", "cmd /c net use " + filePath.substring(0, 2)) == null;
    }

    public static int isInDirectory(File currFile, File toFind, int recursionLevel) {
        if (currFile == null) {
            return -1;
        }
        if (currFile.equals(toFind)) {
            return recursionLevel;
        }
        if (recursionLevel != Integer.MAX_VALUE) {
            ++recursionLevel;
        }
        return FileUtils.isInDirectory(currFile.getParentFile(), toFind, recursionLevel);
    }

    public static String trimSeparators(String path, boolean before, boolean after) {
        while (before && (path.startsWith("/") || path.startsWith("\\"))) {
            path = path.substring(1);
        }
        while (after && (path.endsWith("/") || path.endsWith("\\"))) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean deleteFolder(File root) {
        if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtils.deleteFolder(f);
                ++n2;
            }
        }
        return root.delete();
    }
}

