/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.windowLoad.WindowLoad;

public final class Console {
    public static WindowLoad windowLoad;

    private Console() {
        throw new AssertionError();
    }

    public static void init() {
        if (windowLoad != null) {
            return;
        }
        windowLoad = new WindowLoad();
    }

    public static String getStack(Exception exception, boolean html) {
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        if (html) {
            return writer.toString().replace("\n", "<br/>");
        }
        return writer.toString();
    }

    public static void logInfo(String message, String promptHeaderKey, String promptMsgKey, Object ... args) {
        if (promptHeaderKey != null && promptMsgKey != null) {
            if (args != null && args.length > 0) {
                Prompt.message(Resources.__(promptHeaderKey, new Object[0]), Resources.__(promptMsgKey, args));
            } else {
                Prompt.message(Resources.__(promptHeaderKey, new Object[0]), Resources.__(promptMsgKey, new Object[0]));
            }
        }
        Console.logInfo(message);
    }

    public static void logInfo(String message) {
        System.out.println(message);
    }

    public static void logWarning(String message, String promptHeaderKey, String promptMsgKey, Object ... args) {
        if (promptHeaderKey != null && promptMsgKey != null) {
            if (args != null && args.length > 0) {
                Prompt.error(Resources.__(promptHeaderKey, new Object[0]), Resources.__(promptMsgKey, args));
            } else {
                Prompt.error(Resources.__(promptHeaderKey, new Object[0]), Resources.__(promptMsgKey, new Object[0]));
            }
        }
        Console.logWarning(message);
    }

    public static void logWarning(String message) {
        System.out.println(message);
    }

    public static void logError(String message, boolean fatal, String promptHeaderKey, String promptMsgKey, Object ... args) {
        if (promptHeaderKey != null && promptMsgKey != null) {
            if (args != null && args.length > 0) {
                Prompt.error(Resources.__(promptHeaderKey, new Object[0]), Resources.__(promptMsgKey, args));
            } else {
                Prompt.error(Resources.__(promptHeaderKey, new Object[0]), Resources.__(promptMsgKey, new Object[0]));
            }
        }
        Console.logError(message, fatal);
    }

    public static void logError(String message, boolean fatal) {
        System.err.println(message);
        if (fatal) {
            new RuntimeException(message).printStackTrace();
            if (windowLoad != null) {
                windowLoad.stop();
            }
            System.exit(1);
        }
    }
}

