/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public final class ClipboardTools {
    private static final Transferable EMPTY_CLIPBOARD = new Transferable(){

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(flavor);
        }
    };

    private ClipboardTools() {
        throw new AssertionError();
    }

    public static void store(Transferable toStore) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(toStore, null);
    }

    public static Object get(DataFlavor objectFlavor) {
        try {
            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (contents != null) {
                return contents.getTransferData(objectFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void clear() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(EMPTY_CLIPBOARD, null);
    }
}

