/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.File;
import java.io.RandomAccessFile;
import net.javamon.dev.Bit;

public class ByteArray {
    public static final int MODE_READ = 0;
    public static final int MODE_WRITE = 1;
    public static final int MODE_READ_WRITE = 2;
    private byte[] array;
    private int pointer;
    private boolean read;
    private boolean write;
    private File file;
    private int maxSize;

    public ByteArray(File file) {
        this(file, 2);
    }

    public ByteArray(File file, int mode) {
        this.file = file;
        try {
            RandomAccessFile r = new RandomAccessFile(file, "r");
            this.array = new byte[(int)r.length()];
            r.read(this.array);
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.maxSize = this.array.length;
        this.pointer = 0;
        this.read = true;
        this.write = true;
    }

    public ByteArray(byte[] bytes, int mode) {
        this(bytes, -1, mode);
    }

    public ByteArray(byte[] bytes, int maxSize, int mode) {
        this.maxSize = maxSize;
        this.array = bytes;
        if (bytes == null) {
            if (maxSize < 0) {
                throw new RuntimeException("received no bytes during construction, but max size was not set");
            }
            this.array = new byte[maxSize];
        } else {
            this.maxSize = bytes.length;
        }
        this.pointer = 0;
        this.read = mode == 0 || mode == 2;
        this.write = mode == 1 || mode == 2;
    }

    public void save() {
        if (this.file != null && this.canWrite()) {
            try {
                RandomAccessFile r = new RandomAccessFile(this.file, "r");
                if (r.length() > (long)this.maxSize) {
                    r.setLength(this.maxSize);
                }
                r.seek(0L);
                int i = 0;
                while (i < this.maxSize) {
                    r.writeByte(this.array[i]);
                    ++i;
                }
                r.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("file handle is null");
        }
    }

    public void seek(int pos) {
        if (pos < 0 || pos >= this.maxSize) {
            throw new RuntimeException("the given parameter " + pos + " is outside array bounds. " + "The pointer was not changed");
        }
        this.pointer = pos;
    }

    public boolean isEnd() {
        return this.pointer >= this.maxSize;
    }

    public int getPointer() {
        return this.pointer;
    }

    public boolean extend(int newSize) {
        if (!this.canWrite() || newSize <= this.maxSize) {
            return false;
        }
        if (newSize > this.array.length) {
            byte[] newArray = new byte[newSize];
            int i = 0;
            while (i < this.array.length) {
                newArray[i] = this.array[i];
                ++i;
            }
            this.array = newArray;
        } else {
            int i = this.maxSize;
            while (i < newSize) {
                this.array[i] = 0;
                ++i;
            }
        }
        this.maxSize = newSize;
        return true;
    }

    public boolean shrink(int newSize, byte value, boolean allocateNew) {
        if (!this.canWrite() || newSize >= this.maxSize) {
            return false;
        }
        if (allocateNew) {
            byte[] newArray = new byte[newSize];
            int i = 0;
            while (i < newSize) {
                newArray[i] = value;
                ++i;
            }
            this.array = newArray;
        } else {
            int i = 0;
            while (i < newSize) {
                this.array[i] = value;
                ++i;
            }
        }
        this.maxSize = newSize;
        return true;
    }

    public boolean truncate(int newSize, byte value) {
        if (!this.canWrite()) {
            return false;
        }
        byte[] newArray = null;
        if (newSize > this.maxSize) {
            newArray = new byte[newSize];
            System.arraycopy(this.array, 0, newArray, 0, this.maxSize);
            int i = this.maxSize;
            while (i < newSize) {
                newArray[i] = value;
                ++i;
            }
        } else if (newSize < this.maxSize) {
            newArray = new byte[newSize];
            System.arraycopy(this.array, 0, newArray, 0, newSize);
            this.pointer = 0;
        }
        if (newArray != null) {
            this.array = newArray;
            this.maxSize = newSize;
        }
        return true;
    }

    public int length() {
        return this.maxSize;
    }

    public byte[] getArray() {
        return this.array;
    }

    private boolean canRead() {
        if (!this.read) {
            throw new RuntimeException("reading is not permitted for this file");
        }
        return this.read;
    }

    private boolean canWrite() {
        if (!this.write) {
            throw new RuntimeException("writing is not permitted for this file");
        }
        return this.write;
    }

    private boolean outOfBounds(int pos, int size) {
        if (pos > this.maxSize - size) {
            throw new RuntimeException("given position " + pos + " is outside array bounds");
        }
        return pos > this.maxSize - size;
    }

    public void setArray(byte[] bytes, int mode) {
        if (bytes.length > this.array.length) {
            this.array = bytes;
        } else {
            int i = 0;
            while (i < bytes.length) {
                this.array[i] = bytes[i];
                ++i;
            }
        }
        this.maxSize = bytes.length;
        this.pointer = 0;
        this.read = mode == 0 || mode == 2;
        this.write = mode == 1 || mode == 2;
    }

    public void setArray(byte[] bytes, int maxSize, int mode) {
        if (maxSize > this.array.length) {
            this.array = new byte[maxSize];
        }
        int i = 0;
        while (i < maxSize) {
            this.array[i] = bytes[i];
            ++i;
        }
        this.maxSize = maxSize;
        this.pointer = 0;
        this.read = mode == 0 || mode == 2;
        this.write = mode == 1 || mode == 2;
    }

    public int readBit(int posToRead, int byteSubPos) {
        if (byteSubPos >= 8) {
            throw new RuntimeException("cannot read bit; byte position " + byteSubPos + " is greater than number of bits in a byte");
        }
        int b = this.readUnsignedByte(posToRead);
        return Bit.get(b, byteSubPos);
    }

    public boolean readBitAsBoolean(int posToRead, int byteSubPos) {
        return this.readBit(posToRead, byteSubPos) == 1;
    }

    public void writeBit(int posToWrite, int byteSubPos, int bitToSet) {
        this.writeBitAsBoolean(posToWrite, byteSubPos, bitToSet >= 1);
    }

    public void writeBitAsBoolean(int posToWrite, int byteSubPos, boolean bitToSet) {
        if (byteSubPos >= 8) {
            throw new RuntimeException("cannot write bit; byte position " + byteSubPos + " is greater than number of bits in a byte");
        }
        int b = this.readUnsignedByte(posToWrite);
        if (bitToSet) {
            b = Bit.set(b, byteSubPos);
        }
        if (!bitToSet) {
            b = Bit.unSet(b, byteSubPos);
        }
        this.writeByte(b, posToWrite);
    }

    public int readSignedByte() {
        int b = this.readSignedByte(this.pointer);
        ++this.pointer;
        return b;
    }

    public int readSignedByte(int pos) {
        return (byte)this.readUnsignedByte(pos);
    }

    public int readUnsignedByte() {
        int b = this.readUnsignedByte(this.pointer);
        ++this.pointer;
        return b;
    }

    public int readUnsignedByte(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 1)) {
            return 0;
        }
        return this.array[pos] & 0xFF;
    }

    public void writeByte(int b) {
        this.writeByte(b, this.pointer);
        ++this.pointer;
    }

    public void writeByte(int b, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, 1)) {
            return;
        }
        this.array[pos] = (byte)(b & 0xFF);
    }

    public int readSignedShort() {
        int s = this.readSignedShort(this.pointer);
        this.pointer += 2;
        return s;
    }

    public int readSignedShort(int pos) {
        return (short)this.readUnsignedShort(pos);
    }

    public int readUnsignedShort() {
        int s = this.readUnsignedShort(this.pointer);
        this.pointer += 2;
        return s;
    }

    public int readUnsignedShort(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 2)) {
            return 0;
        }
        int i = this.readUnsignedByte(pos);
        int j = this.readUnsignedByte(pos + 1);
        return i * 256 + j;
    }

    public void writeShort(int s) {
        this.writeShort(s, this.pointer);
        this.pointer += 2;
    }

    public void writeShort(int s, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, 2)) {
            return;
        }
        this.writeByte(s >> 8 & 0xFF, pos);
        this.writeByte(s & 0xFF, pos + 1);
    }

    public int readSignedInt() {
        int i = this.readSignedInt(this.pointer);
        this.pointer += 4;
        return i;
    }

    public int readSignedInt(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 4)) {
            return 0;
        }
        int i = this.readUnsignedByte(pos);
        int j = this.readUnsignedByte(pos + 1);
        int k = this.readUnsignedByte(pos + 2);
        int l = this.readUnsignedByte(pos + 3);
        return i << 24 | j << 16 | k << 8 | l;
    }

    public long readUnsignedInt() {
        long i = this.readUnsignedInt(this.pointer);
        this.pointer += 4;
        return i;
    }

    public long readUnsignedInt(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 4)) {
            return 0L;
        }
        long i = this.readUnsignedByte(pos);
        long j = this.readUnsignedByte(pos + 1);
        long k = this.readUnsignedByte(pos + 2);
        long l = this.readUnsignedByte(pos + 3);
        return i * 0x1000000L + j * 65536L + k * 256L + l;
    }

    public void writeInt(int i) {
        this.writeInt(i, this.pointer);
        this.pointer += 4;
    }

    public void writeInt(int i, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, 4)) {
            return;
        }
        this.writeByte(i >> 24 & 0xFF, pos);
        this.writeByte(i >> 16 & 0xFF, pos + 1);
        this.writeByte(i >> 8 & 0xFF, pos + 2);
        this.writeByte(i & 0xFF, pos + 3);
    }

    public long readSignedLong() {
        long i = this.readSignedLong(this.pointer);
        this.pointer += 8;
        return i;
    }

    public long readSignedLong(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 8)) {
            return 0L;
        }
        long i = this.readUnsignedByte(pos);
        long j = this.readUnsignedByte(pos + 1);
        long k = this.readUnsignedByte(pos + 2);
        long l = this.readUnsignedByte(pos + 3);
        long m = this.readUnsignedByte(pos + 4);
        long n = this.readUnsignedByte(pos + 5);
        long o = this.readUnsignedByte(pos + 6);
        long p = this.readUnsignedByte(pos + 7);
        return i << 56 | j << 48 | k << 40 | l << 32 | m << 24 | n << 16 | o << 8 | p;
    }

    public void writeLong(long i) {
        this.writeLong(i, this.pointer);
        this.pointer += 8;
    }

    public void writeLong(long i, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, 8)) {
            return;
        }
        this.writeByte((int)(i >> 56 & 0xFFL), pos);
        this.writeByte((int)(i >> 48 & 0xFFL), pos + 1);
        this.writeByte((int)(i >> 40 & 0xFFL), pos + 2);
        this.writeByte((int)(i >> 32 & 0xFFL), pos + 3);
        this.writeByte((int)(i >> 24 & 0xFFL), pos + 4);
        this.writeByte((int)(i >> 16 & 0xFFL), pos + 5);
        this.writeByte((int)(i >> 8 & 0xFFL), pos + 6);
        this.writeByte((int)(i & 0xFFL), pos + 7);
    }

    public boolean readBoolean() {
        boolean b = this.readBoolean(this.pointer);
        ++this.pointer;
        return b;
    }

    public boolean readBoolean(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 1)) {
            return false;
        }
        return this.readUnsignedByte(pos) == 1;
    }

    public void writeBoolean(boolean b) {
        this.writeBoolean(b, this.pointer);
        ++this.pointer;
    }

    public void writeBoolean(boolean b, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, 1)) {
            return;
        }
        if (b) {
            this.writeByte(1, pos);
        } else {
            this.writeByte(0, pos);
        }
    }

    public String read(int length) {
        String toReturn = this.read(length, this.pointer);
        this.pointer += length;
        return toReturn;
    }

    public String read(int length, int pos) {
        if (!this.canRead() || this.outOfBounds(pos, length)) {
            return null;
        }
        String toReturn = "";
        int i = 0;
        while (i < length) {
            if (this.array[pos + i] != 0) {
                toReturn = String.valueOf(toReturn) + (char)this.array[pos + i];
            }
            ++i;
        }
        if (toReturn.length() == 0 || toReturn.charAt(0) == '\u0000') {
            return null;
        }
        return toReturn.trim();
    }

    public void write(String s) {
        this.write(s, this.pointer);
        this.pointer += s.length();
    }

    public void write(String s, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, s.length())) {
            return;
        }
        int i = 0;
        while (i < s.length()) {
            this.writeByte(s.charAt(i), pos + i);
            ++i;
        }
    }

    public float readFloat() {
        return Float.parseFloat(this.readFloatAsString());
    }

    public float readFloat(int pos) {
        return Float.parseFloat(this.readFloatAsString(pos));
    }

    public String readFloatAsString() {
        String toReturn = this.readFloatAsString(this.pointer);
        this.pointer += 4;
        return toReturn;
    }

    public String readFloatAsString(int pos) {
        if (!this.canRead() || this.outOfBounds(pos, 4)) {
            return null;
        }
        return String.valueOf(this.readUnsignedByte(pos)) + "." + this.readUnsignedByte(pos + 1) + this.readUnsignedByte(pos + 2) + this.readUnsignedByte(pos + 3);
    }

    public void writeFloat(float f) {
        this.writeFloat(f, this.pointer);
        this.pointer += 4;
    }

    public void writeFloat(float f, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, 4)) {
            return;
        }
        String toWrite = String.format("%.3f", Float.valueOf(f));
        this.writeByte(Integer.parseInt(String.valueOf(toWrite.charAt(0))), pos);
        this.writeByte(Integer.parseInt(String.valueOf(toWrite.charAt(0))), pos + 1);
        this.writeByte(Integer.parseInt(String.valueOf(toWrite.charAt(0))), pos + 2);
        this.writeByte(Integer.parseInt(String.valueOf(toWrite.charAt(0))), pos + 3);
    }

    public byte[] readBytes(int length) {
        byte[] toReturn = this.readBytes(length, this.pointer);
        this.pointer += length;
        return toReturn;
    }

    public void readBytesInto(int length, byte[] toFill) {
        this.readBytesInto(length, toFill, this.pointer);
        this.pointer += length;
    }

    public byte[] readBytes(int length, int pos) {
        if (!this.canRead() || this.outOfBounds(pos, length)) {
            return null;
        }
        byte[] toReturn = new byte[length];
        int i = 0;
        while (i < length) {
            toReturn[i] = this.array[pos + i];
            ++i;
        }
        return toReturn;
    }

    public void readBytesInto(int length, byte[] toFill, int pos) {
        if (!this.canRead() || toFill == null || this.outOfBounds(pos, length) || length > toFill.length) {
            return;
        }
        int i = 0;
        while (i < length) {
            toFill[i] = this.array[pos + i];
            ++i;
        }
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, this.pointer);
        this.pointer += bytes.length;
    }

    public void writeBytes(byte[] bytes, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, bytes.length)) {
            return;
        }
        int i = 0;
        while (i < bytes.length) {
            this.writeByte(bytes[i], pos + i);
            ++i;
        }
    }

    public void writeBytes(byte[] bytes, int offset, int length) {
        this.writeBytes(bytes, offset, length, this.pointer);
        this.pointer += length;
    }

    public void writeBytes(byte[] bytes, int offset, int length, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, length)) {
            return;
        }
        int i = 0;
        while (i < length) {
            this.writeByte(bytes[i + offset], pos + i);
            ++i;
        }
    }

    public void copyBytes(ByteArray source, int sourcePos, int destPos, int length) {
        if (!this.canWrite() || this.outOfBounds(destPos, length)) {
            return;
        }
        if (!source.canRead() || source.outOfBounds(sourcePos, length)) {
            return;
        }
        int i = 0;
        while (i < length) {
            this.writeByte(source.getArray()[sourcePos + i], destPos + i);
            ++i;
        }
    }

    public void fill(int length, byte value) {
        this.fill(length, value, this.pointer);
        this.pointer += length;
    }

    public void fill(int length, byte value, int pos) {
        if (!this.canWrite() || this.outOfBounds(pos, length)) {
            return;
        }
        int i = 0;
        while (i < length) {
            this.writeByte(value, pos + i);
            ++i;
        }
    }
}

