/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

public final class Bit {
    private Bit() {
        throw new AssertionError();
    }

    public static int set(int number, int positionToSet) {
        return number | 1 << positionToSet;
    }

    public static int unSet(int number, int positionToSet) {
        return number & ~(1 << positionToSet);
    }

    public static int get(int number, int positionToGet) {
        if ((number & 1 << positionToGet) == 1 << positionToGet) {
            return 1;
        }
        return 0;
    }

    public static boolean isSet(int number, int positionToGet) {
        return Bit.get(number, positionToGet) == 1;
    }

    public static int getSum(int number) {
        return Integer.bitCount(number);
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            buffer.append(Character.forDigit(bytes[i] >> 4 & 0xF, 16));
            buffer.append(Character.forDigit(bytes[i] & 0xF, 16));
            ++i;
        }
        return buffer.toString();
    }

    public static void toBytes(String hex, byte[] destination) {
        if (hex == null || destination == null) {
            throw new RuntimeException("cannot convert hex to bytes; source string or destination array is null");
        }
        if (hex.length() != destination.length * 2) {
            throw new RuntimeException("cannot convert hex to bytes; source string has invalid length " + hex.length() + "(should be " + destination.length * 2 + "; are you sure you made the destination byte array the correct size?)");
        }
        int i = 0;
        while (i < hex.length()) {
            destination[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            i += 2;
        }
    }
}

