/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.io.File;
import net.javamon.dev.ByteArray;
import net.javamon.dev.Prompt;
import net.javamon.dev.PropertiesFile;
import net.javamon.dev.Resources;

public class BinaryFile {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INTEGER = 2;
    private File location;
    private ByteArray file;
    private boolean allowWrite;
    private boolean isError;

    protected BinaryFile(String fullPath, int offsetSize, boolean allowWrite, boolean create, boolean errorIfExists) {
        this.allowWrite = allowWrite;
        this.isError = false;
        this.location = new File(fullPath);
        if (!this.location.exists() && (!create || !allowWrite) || this.location.exists() && errorIfExists) {
            this.error();
            return;
        }
        try {
            if (!this.location.exists() && create) {
                this.location.getParentFile().mkdirs();
                this.location.createNewFile();
                this.file = new ByteArray(this.location);
                this.file.extend(offsetSize);
                return;
            }
            this.file = allowWrite ? new ByteArray(this.location) : new ByteArray(this.location, 0);
            if (offsetSize > 0 && this.file.length() < offsetSize) {
                this.file.extend(offsetSize);
                int i = 0;
                while (i < offsetSize) {
                    this.file.writeByte(0);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error();
            return;
        }
    }

    public boolean isError() {
        return this.isError;
    }

    public ByteArray getFile() {
        if (this.isError) {
            return null;
        }
        return this.file;
    }

    public void close(boolean save) {
        if (this.isError) {
            return;
        }
        if (save && this.allowWrite) {
            try {
                this.file.save();
            }
            catch (Exception e) {
                Prompt.error(Resources.__("appSaveErrorH", new Object[0]), Resources.__("appSaveErrorMsg", this.location.getAbsolutePath()));
                return;
            }
        }
        this.error();
    }

    public void add(int numBytes) {
        if (this.isError) {
            return;
        }
        this.file.truncate(this.file.length() + numBytes, (byte)0);
    }

    public boolean fillRegion(int offset, int length, byte value) {
        if (this.isError) {
            return false;
        }
        if (length <= 0 || length >= this.file.length() || offset >= this.file.length() || offset < 0) {
            Prompt.warning(Resources.__("appBinaryIllegalFillH", new Object[0]), Resources.__("appBinaryIllegalFillMsg", this.location.getAbsolutePath()));
            return false;
        }
        this.file.fill(length, value, offset);
        return true;
    }

    public boolean deleteRegion(int offset, int length) {
        if (this.isError) {
            return false;
        }
        if (length <= 0 || offset < 0 || length + offset > this.file.length()) {
            Prompt.warning(Resources.__("appBinaryIllegalDeleteH", new Object[0]), Resources.__("appBinaryIllegalDeleteMsg", this.location.getAbsolutePath()));
            return false;
        }
        if (length + offset == this.file.length() && offset == 0) {
            this.file.truncate(0, (byte)0);
            return true;
        }
        byte[] before = null;
        if (offset > 0) {
            before = this.file.readBytes(offset, 0);
        }
        byte[] after = null;
        int afterNumBytes = this.file.length() - (offset + length);
        if (afterNumBytes > 0) {
            after = this.file.readBytes(afterNumBytes, offset + length);
        }
        this.file.truncate(this.file.length() - length, (byte)0);
        this.file.seek(0);
        if (before != null) {
            this.file.writeBytes(before);
        }
        if (after != null) {
            this.file.writeBytes(after);
        }
        return true;
    }

    public String[] getEntries(PropertiesFile stringFile, int offset, int entryLength, int entryOffset, boolean prependIndices, int type) {
        if (this.isError) {
            return null;
        }
        String[] entries = new String[(this.file.length() - offset) / entryLength];
        if (entries.length == 0) {
            return null;
        }
        int i = 0;
        while (i < entries.length) {
            int entryIndex;
            this.file.seek(i * entryLength + entryOffset + offset);
            switch (type) {
                case 0: {
                    entryIndex = this.file.readUnsignedByte();
                    break;
                }
                case 1: {
                    entryIndex = this.file.readUnsignedShort();
                    break;
                }
                case 2: {
                    entryIndex = this.file.readSignedInt();
                    break;
                }
                default: {
                    entryIndex = this.file.readUnsignedByte();
                }
            }
            entries[i] = stringFile.get(String.valueOf(entryIndex));
            if (entries[i] == null) {
                return null;
            }
            if (prependIndices) {
                entries[i] = Resources.__("appStringIndex", i, entries[i]);
            }
            ++i;
        }
        return entries;
    }

    public int[] getEntries(int offset, int entryLength, int entryOffset, int type) {
        if (this.isError) {
            return null;
        }
        int[] entries = new int[(this.file.length() - offset) / entryLength];
        if (entries.length == 0) {
            return null;
        }
        int i = 0;
        while (i < entries.length) {
            this.file.seek(i * entryLength + entryOffset + offset);
            switch (type) {
                case 0: {
                    entries[i] = this.file.readUnsignedByte();
                    break;
                }
                case 1: {
                    entries[i] = this.file.readUnsignedShort();
                    break;
                }
                case 2: {
                    entries[i] = this.file.readSignedInt();
                    break;
                }
                default: {
                    entries[i] = this.file.readUnsignedByte();
                }
            }
            ++i;
        }
        return entries;
    }

    private void error() {
        this.location = null;
        this.file = null;
        this.isError = true;
    }
}

