/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import net.javamon.dev.utils.comboBox.AbstractMultiplexableRenderer;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.comboBox.JComboBoxHelper;
import net.javamon.dev.utils.comboBox.MultiplexRenderer;
import net.javamon.dev.utils.comboBox.ToggleableItemRenderer;
import net.javamon.dev.utils.comboBox.ToolTipRenderer;

public abstract class AbstractGenerator {
    protected String[] entries;
    protected String[] toolTips;
    protected boolean[][] enabledEntries;

    protected String[] lastEntries() {
        return this.entries;
    }

    protected String[] lastToolTips() {
        return this.toolTips;
    }

    protected boolean[][] lastEnabledEntries() {
        return this.enabledEntries;
    }

    protected void setEntries(ExtendableJComboBox<String> box, String lastEntry, boolean allowResize) {
        JComboBoxHelper.load(box, this.entries, lastEntry, allowResize);
    }

    protected void setEnabledEntries(MultiplexRenderer renderer, int rendererID, int generatedID) {
        AbstractMultiplexableRenderer r;
        if (renderer.getRenderers() == null) {
            return;
        }
        if (rendererID > renderer.getRenderers().length || rendererID < 0) {
            rendererID = 0;
        }
        if (generatedID > this.enabledEntries.length || rendererID < 0) {
            generatedID = 0;
        }
        if ((r = renderer.getRenderers()[rendererID]) instanceof ToggleableItemRenderer) {
            ((ToggleableItemRenderer)r).setEntries(this.enabledEntries[generatedID]);
        }
    }

    protected void setToolTips(MultiplexRenderer renderer, int rendererID) {
        AbstractMultiplexableRenderer r;
        if (renderer.getRenderers() == null) {
            return;
        }
        if (rendererID > renderer.getRenderers().length || rendererID < 0) {
            rendererID = 0;
        }
        if ((r = renderer.getRenderers()[rendererID]) instanceof ToolTipRenderer) {
            ((ToolTipRenderer)r).setToolTips(this.toolTips);
        }
    }

    protected void clear(int length, int numSets) {
        this.entries = new String[length];
        this.toolTips = new String[length];
        this.enabledEntries = new boolean[numSets][length];
    }
}

