/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.javamon.dev.AbstractBinaryLoadListener;
import net.javamon.dev.AbstractGenerator;
import net.javamon.dev.ImageCache;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.RevertFileListener;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.layout.AbstractPanel;

public abstract class AbstractFrame
implements WindowListener {
    protected static final String ZERO = "0";
    protected static final String EMPTY = "";
    protected static final String NONE = "none";
    private static final int MAX_WIDTH = 1278;
    private static final int MAX_HEIGHT = 768;
    protected JFrame frame;
    protected JMenuItem revert;
    protected final AbstractGenerator generator;
    private static AbstractFrame mainFrame;

    public AbstractFrame(String titleKey, int width, int height, Object ... args) {
        this.frame = args == null || args.length == 0 ? new JFrame(Resources.__(titleKey, new Object[0])) : new JFrame(Resources.__(titleKey, args));
        this.frame.setIconImage(ImageCache.get(Resources.getAppImage("icon")).get());
        this.frame.setDefaultCloseOperation(0);
        this.frame.setMinimumSize(new Dimension(width, height));
        this.frame.setResizable(false);
        this.frame.setLayout(new GridLayout(0, 1));
        this.frame.addWindowListener(this);
        if (width > 1278 || height > 768) {
            System.err.println("WARNING: requested size " + width + "x" + height + " for frame '" + this.frame.getTitle() + "' exceeds the low-resolution target " + 1278 + "x" + 768 + ";" + "\n\tit is strongly recommended that you choose a smaller size " + "or divide your editor into multiple smaller frames" + "\n\tto ensure comptability across a wider range of devices");
        }
        this.generator = this.createGenerator();
        this.setPrimaryListeners();
        this.createMenu();
        this.setFrame();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hide();
        if (mainFrame != null) {
            mainFrame.show();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    public abstract AbstractPanel main();

    protected abstract AbstractGenerator getGenerator();

    protected abstract AbstractGenerator createGenerator();

    protected abstract void setPrimaryListeners();

    protected abstract boolean requestResources();

    protected abstract void returnResources(boolean var1);

    protected abstract boolean validate();

    protected abstract void createMenu();

    protected abstract void setFrame();

    public static JMenu createJMenu(String textKey, String toolTipKey, boolean isEnabled) {
        JMenu menu = new JMenu(HTML.wrap(Resources.__(textKey, new Object[0])));
        menu.setToolTipText(HTML.wrap(Resources.__(toolTipKey, new Object[0])));
        menu.setEnabled(isEnabled);
        return menu;
    }

    public static JMenuItem setJMenuItem(JComponent parent, String textKey, String toolTipKey, ActionListener listener, boolean isEnabled, boolean checkBox, int keyEvent, boolean shift, boolean alt, boolean control) {
        JMenuItem item;
        if (checkBox) {
            item = new JCheckBoxMenuItem(HTML.wrap(Resources.__(textKey, new Object[0])));
            item.setMargin(new Insets(5, 5, 5, 5));
            item.setIconTextGap(5);
        } else {
            item = new JMenuItem(HTML.wrap(Resources.__(textKey, new Object[0])));
        }
        item.setToolTipText(HTML.wrap(Resources.__(toolTipKey, new Object[0])));
        item.setEnabled(isEnabled);
        if (parent instanceof JMenu) {
            item.setHorizontalAlignment(2);
            item.setHorizontalTextPosition(2);
        }
        if (listener != null) {
            item.addActionListener(listener);
            AbstractFrame.setShortcut(item, keyEvent, shift, alt, control);
        }
        parent.add(item);
        return item;
    }

    public static void setShortcut(JMenuItem item, int keyEvent, boolean shift, boolean alt, boolean control) {
        if (keyEvent == 0) {
            return;
        }
        int mask = 0;
        if (shift) {
            mask |= 1;
        }
        if (alt) {
            mask |= 8;
        }
        if (control) {
            mask |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        item.setAccelerator(KeyStroke.getKeyStroke(keyEvent, mask));
    }

    public static void setMainFrame(AbstractFrame mainFrame) {
        AbstractFrame.mainFrame = mainFrame;
    }

    public void show() {
        Prompt.setMessageComponent(this.frame);
        this.frame.setVisible(true);
        if (!this.requestResources() || !this.validate()) {
            this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
        }
    }

    public void hide() {
        this.frame.setVisible(false);
        this.returnResources(true);
    }

    public void revert() {
        this.frame.setVisible(false);
        this.returnResources(false);
        if (mainFrame != null) {
            mainFrame.show();
        }
    }

    protected void pack() {
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
    }

    protected void ready(AbstractBinaryLoadListener loadListener) {
        loadListener.configureEditor();
        loadListener.refreshEditor();
        loadListener.load(0);
    }

    protected void setJMenuBar(JMenuBar menuBar, boolean allowRevert) {
        if (allowRevert) {
            this.revert = AbstractFrame.setJMenuItem(menuBar, "mainMenuRevert", "mainMenuRevertTT", new RevertFileListener(this), true, false, 0, false, false, false);
        }
        this.frame.setJMenuBar(menuBar);
    }
}

