/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.javamon.dev.AbstractBinaryLoadListener;
import net.javamon.dev.AbstractFrame;
import net.javamon.dev.BinaryFile;
import net.javamon.dev.Prompt;
import net.javamon.dev.PropertiesFile;
import net.javamon.dev.Resources;

public abstract class AbstractBinarySaveListener
implements ActionListener {
    protected AbstractFrame parent;
    protected BinaryFile file;
    private AbstractBinaryLoadListener loadListener;

    protected AbstractBinarySaveListener(AbstractFrame parent, AbstractBinaryLoadListener loadListener) {
        this.loadListener = loadListener;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.file = this.loadListener.file;
        if (this.file != null) {
            this.listenerSave();
        } else {
            Prompt.error(Resources.__("appErrorSaveH", new Object[0]), Resources.__("appErrorSaveMsg", new Object[0]));
        }
    }

    protected abstract void save();

    protected abstract String editorPrefix(int var1);

    protected abstract String editorSuggestion(int var1);

    protected AbstractBinaryLoadListener getLoadListener() {
        return this.loadListener;
    }

    protected void startSave(int index, int offsetSize, boolean saveEditorIDs, String forceID) {
        if (this.file != null) {
            this.file.getFile().seek(index * offsetSize);
        }
    }

    protected void endSave(String promptTag, Object ... args) {
        if (args != null && args.length > 0) {
            Prompt.message(Resources.__(String.valueOf(promptTag) + "SaveSuccessH", new Object[0]), Resources.__(String.valueOf(promptTag) + "SaveSuccessMsg", args));
        } else {
            Prompt.message(Resources.__(String.valueOf(promptTag) + "SaveSuccessH", new Object[0]), Resources.__(String.valueOf(promptTag) + "SaveSuccessMsg", new Object[0]));
        }
    }

    protected void writeText(int index, int defaultValue, boolean isShort, PropertiesFile write, String text) {
        if ((text == null || text.length() == 0) && index == defaultValue || text != null && text.length() > 0) {
            write.add(String.valueOf(index), text);
        } else if ((text == null || text.length() == 0) && defaultValue == -1) {
            write.add(String.valueOf(index), "");
        }
        int value = index;
        if ((text == null || text.length() == 0) && defaultValue != -1) {
            value = defaultValue;
        }
        if (isShort) {
            this.file.getFile().writeShort(value);
        } else {
            this.file.getFile().writeByte(value);
        }
    }

    protected void listenerSave() {
        this.save();
        this.loadListener.refreshEditor();
        this.loadListener.load(0);
    }
}

