/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import net.javamon.dev.AbstractFrame;
import net.javamon.dev.BinaryFile;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.Validate;

public abstract class AbstractBinaryLoadListener
implements ActionListener {
    protected AbstractFrame parent;
    protected BinaryFile file;

    protected AbstractBinaryLoadListener(AbstractFrame parent) {
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.file = this.getFile();
        if (this.file != null) {
            this.load();
        } else {
            Prompt.error(Resources.__("appErrorLoadH", new Object[0]), Resources.__("appErrorLoadMsg", new Object[0]));
        }
    }

    protected abstract void refreshEditor();

    protected abstract BinaryFile getFile();

    protected abstract void load();

    protected abstract void load(int var1);

    protected abstract void clearData(int var1);

    protected void configureEditor() {
        this.file = this.getFile();
    }

    protected boolean startLoad(int index, int offsetSize, ExtendableJComboBox<String> toSelect, boolean disableIfZero, AbstractPanel toEnable, JMenuItem ... items) {
        if (this.clear(index, toSelect, toEnable, items)) {
            return false;
        }
        Validate.disable();
        if (toSelect != null) {
            toSelect.setSelectedIndexNoAction(index);
        }
        if (disableIfZero && items != null) {
            int i = 0;
            while (i < items.length) {
                items[i].setEnabled(index > 0);
                ++i;
            }
        }
        if (toEnable != null) {
            toEnable.setEnabled(!disableIfZero || index > 0);
        }
        if (this.file != null) {
            this.file.getFile().seek(index * offsetSize);
        }
        return true;
    }

    protected void endLoad() {
        this.validate();
        Validate.enable();
    }

    protected void validate() {
        this.parent.main().validate();
    }

    private boolean clear(int index, ExtendableJComboBox<String> toSelect, AbstractPanel toEnable, JMenuItem ... items) {
        boolean shouldDisable;
        boolean bl = shouldDisable = index == -1 || toSelect != null && toSelect.getItemCount() == 0;
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                items[i].setEnabled(!shouldDisable);
                ++i;
            }
        }
        if (shouldDisable) {
            toEnable.setEnabled(false);
            Validate.disable();
            this.clearData(index);
            Validate.enable();
            this.validate();
            return true;
        }
        return false;
    }
}

