/*
 * Decompiled with CFR 0.152.
 */
package net.javamon.dev;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.javamon.dev.AbstractBinaryLoadListener;
import net.javamon.dev.AbstractFrame;
import net.javamon.dev.BinaryFile;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;

public abstract class AbstractBinaryDeleteListener
implements ActionListener {
    protected AbstractFrame parent;
    protected BinaryFile file;
    private AbstractBinaryLoadListener loadListener;

    protected AbstractBinaryDeleteListener(AbstractFrame parent, AbstractBinaryLoadListener loadListener) {
        this.loadListener = loadListener;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.file = this.loadListener.file;
        if (this.loadListener.file != null) {
            this.listenerDelete();
        } else {
            Prompt.error(Resources.__("appErrorDeleteH", new Object[0]), Resources.__("appErrorDeleteMsg", new Object[0]));
        }
    }

    protected abstract boolean delete();

    protected abstract void deleteEntryStrings(int var1);

    protected boolean delete(int index, String name, int offset, int entrySize, String promptTag) {
        int choice = Prompt.show(Resources.__(String.valueOf(promptTag) + "DeleteConfirmH", new Object[0]), Resources.__(String.valueOf(promptTag) + "DeleteConfirmMsg", name));
        if (choice == 0 && this.file.deleteRegion(offset + index * entrySize, entrySize)) {
            this.deleteEntryStrings(index);
            Prompt.message(Resources.__(String.valueOf(promptTag) + "DeleteSuccessH", new Object[0]), Resources.__(String.valueOf(promptTag) + "DeleteSuccessMsg", name));
            return true;
        }
        return false;
    }

    protected void listenerDelete() {
        if (this.delete()) {
            this.loadListener.refreshEditor();
            this.loadListener.load(0);
        }
    }
}

