/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import edu.uwyo.crawl.ui.tree.FileNodeToolTipTree;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;

public class WideTreeUI
extends BasicTreeUI {
    private final Runnable configureRunnable = new Runnable(){

        @Override
        public void run() {
            WideTreeUI.this.configureLayoutCache();
        }
    };
    private JScrollPane scrollPane;
    private boolean resize;
    private final FileNodeToolTipTree tree;
    private final boolean largeModel;

    protected WideTreeUI(FileNodeToolTipTree tree, boolean largeModel) {
        this.tree = tree;
        this.largeModel = largeModel;
        tree.addTreeExpansionListener(new CollapseListener());
        tree.setUI(this);
        this.setLargeModel(true);
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        if (this.largeModel && !this.isLargeModel()) {
            this.setLargeModel(true);
        }
        return new WideNodeDimensionsHandler();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tree.addPropertyChangeListener("ancestor", new TreePropertyChangeListener());
    }

    private void reportSizeChange() {
        this.resize = true;
        this.configureLayoutCache();
        this.resize = false;
        SwingUtilities.invokeLater(this.configureRunnable);
    }

    private class CollapseListener
    implements TreeExpansionListener {
        private CollapseListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            WideTreeUI.this.reportSizeChange();
        }
    }

    private class ScrollAdjustmentListener
    implements AdjustmentListener {
        private ScrollAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            WideTreeUI.this.configureLayoutCache();
        }
    }

    private class ScrollComponentListener
    implements ComponentListener {
        private ScrollComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            WideTreeUI.this.reportSizeChange();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class TreePropertyChangeListener
    implements PropertyChangeListener {
        private TreePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (WideTreeUI.this.tree.getParent() instanceof JViewport && WideTreeUI.this.tree.getParent().getParent() instanceof JScrollPane) {
                WideTreeUI.this.scrollPane = (JScrollPane)WideTreeUI.this.tree.getParent().getParent();
                WideTreeUI.this.scrollPane.addComponentListener(new ScrollComponentListener());
                JScrollBar horizontal = WideTreeUI.this.scrollPane.getHorizontalScrollBar();
                horizontal.addAdjustmentListener(new ScrollAdjustmentListener());
            }
        }
    }

    private class WideNodeDimensionsHandler
    extends BasicTreeUI.NodeDimensionsHandler {
        private WideNodeDimensionsHandler() {
            super(WideTreeUI.this);
        }

        @Override
        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
            int rowX = this.getRowX(row, depth);
            if (WideTreeUI.this.resize && WideTreeUI.this.scrollPane != null) {
                dimensions.width = WideTreeUI.this.scrollPane.getViewport().getWidth() - rowX;
            } else if (WideTreeUI.this.tree.getWidth() > rowX + dimensions.width) {
                dimensions.width = WideTreeUI.this.tree.getWidth() - rowX;
            }
            return dimensions;
        }
    }
}

