/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import edu.uwyo.crawl.ui.tree.AbstractFileEntryRenderer;
import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import edu.uwyo.crawl.ui.tree.AbstractFileNodePopup;
import edu.uwyo.crawl.ui.tree.DefaultFileEntryRenderer;
import edu.uwyo.crawl.ui.tree.ExpansionState;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import edu.uwyo.crawl.ui.tree.FileNodeToolTipTree;
import edu.uwyo.crawl.ui.tree.FileTreeCellRenderer;
import edu.uwyo.crawl.ui.tree.FileTreeKeyListener;
import edu.uwyo.crawl.ui.tree.FileTreeMouseListener;
import edu.uwyo.crawl.ui.tree.LazyFileLoadListener;
import edu.uwyo.crawl.ui.tree.WideTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import net.javamon.dev.Resources;
import net.javamon.dev.StringUtils;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.layout.AbstractPanel;

public class PanelFileTree
extends AbstractPanel {
    private JScrollPane scrollPane;
    private FileNodeToolTipTree tree;
    private AbstractFileNode root;
    private LazyFileLoadListener treeListener;
    private FileTreeMouseListener treeMouseListener;
    private FileDisplayTree resultTree;
    private JLabelHTML noResults;
    private final AbstractFileNode nodeFactory;
    private final AbstractFileEntryRenderer entryRenderer;
    private final boolean equalRowHeights;

    public PanelFileTree(AbstractFileNode nodeFactory, AbstractFileEntryRenderer entryRenderer, AbstractFileNodePopup nodePopup, boolean largeModel, boolean equalRowHeights, String title, int preferredWidth, int preferredHeight, Object ... args) {
        super(title, preferredWidth, preferredHeight, args);
        this.nodeFactory = nodeFactory;
        this.entryRenderer = entryRenderer == null ? new DefaultFileEntryRenderer() : entryRenderer;
        this.equalRowHeights = equalRowHeights;
        this.setTree(nodePopup, largeModel);
        this.setNoResults();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }

    @Override
    public void validate() {
    }

    public boolean redraw() {
        if (this.resultTree == null || !this.tree.isVisible()) {
            return false;
        }
        String state = ExpansionState.save(this.tree);
        this.updateView(this.resultTree);
        ExpansionState.restore(this.tree, state);
        return true;
    }

    public void updateView(FileDisplayTree resultTree) {
        this.resultTree = resultTree;
        if (resultTree != null && resultTree.isEmpty()) {
            resultTree = null;
        }
        this.tree.setVisible(resultTree != null);
        this.scrollPane.setVisible(resultTree != null);
        this.noResults.setVisible(resultTree == null);
        if (resultTree == null) {
            return;
        }
        this.treeListener.setTree(resultTree);
        this.treeMouseListener.setTree(resultTree);
        if (this.equalRowHeights) {
            Component c = this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, this.root, false, false, false, 1, false);
            this.tree.setRowHeight(c.getPreferredSize().height + 2);
        }
        this.root.setUserObject(resultTree.getPath());
        this.root.removeAllChildren();
        this.root.add(this.nodeFactory.create(null, "defaultFolderSlugForLazyLoadListener"));
        this.root.setToolTipText(HTML.wrap(Resources.__("mainNodeFolderTT", resultTree.size(), StringUtils.getFormattedBytes(resultTree.fileSize()))));
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.collapseRow(0);
        this.scrollPane.setViewportView(this.tree);
    }

    public FileDisplayTree getTree() {
        return this.tree.isVisible() ? this.resultTree : null;
    }

    public Color getTreeBackground() {
        return this.tree.getBackground();
    }

    private void setTree(AbstractFileNodePopup nodePopup, boolean largeModel) {
        this.root = this.nodeFactory.create(null, "root");
        this.tree = new FileNodeToolTipTree(this.root);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.treeListener = new LazyFileLoadListener((DefaultTreeModel)this.tree.getModel(), this.nodeFactory);
        this.tree.setCellRenderer(new FileTreeCellRenderer(this.entryRenderer));
        this.treeMouseListener = new FileTreeMouseListener(this.tree, nodePopup);
        this.tree.addMouseListener(this.treeMouseListener);
        this.tree.addMouseMotionListener(this.treeMouseListener);
        this.tree.addKeyListener(new FileTreeKeyListener(this.tree, nodePopup));
        this.tree.addTreeWillExpandListener(this.treeListener);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setUI(new WideTreeUI(this.tree, largeModel));
        this.tree.setVisible(false);
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width - this.left() - this.right() - this.borderWidth(), this.getPreferredSize().height - this.top() - this.bottom() - this.borderHeight()));
        this.layoutFill(this.scrollPane, 5, this.panel, this.panel, this.panel, this.panel);
        this.add(this.scrollPane);
    }

    private void setNoResults() {
        this.noResults = this.createLabel("mainNoResults", null);
        this.noResults.setForeground(Color.RED);
        this.noResults.setVisible(false);
        this.layout("West", this.noResults, 5, "West", this.panel);
        this.layout("North", this.noResults, 5, "North", this.panel);
        this.add(this.noResults);
    }
}

