/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import net.javamon.dev.Resources;
import net.javamon.dev.StringUtils;
import net.javamon.dev.utils.HTML;

public class LazyFileLoadListener
implements TreeWillExpandListener {
    protected static final String FOLDER_SLUG = "defaultFolderSlugForLazyLoadListener";
    private FileDisplayTree resultTree;
    private final DefaultTreeModel model;
    private final AbstractFileNode nodeFactory;

    protected LazyFileLoadListener(DefaultTreeModel model, AbstractFileNode nodeFactory) {
        this.model = model;
        this.nodeFactory = nodeFactory;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        HashMap<String, FileDisplayTree> map = this.resultTree.getChildren(event.getPath().getPath());
        if (map == null || map.size() == 0) {
            throw new ExpandVetoException(event, "folder is empty");
        }
        AbstractFileNode currNode = (AbstractFileNode)event.getPath().getLastPathComponent();
        try {
            AbstractFileNode child = (AbstractFileNode)currNode.getFirstChild();
            if (child.getUserObject().equals(FOLDER_SLUG)) {
                currNode.remove(currNode.getIndex(child));
            }
        }
        catch (NoSuchElementException child) {
            // empty catch block
        }
        Set<String> children = map.keySet();
        this.add(currNode, children, map, true);
        this.add(currNode, children, map, false);
        this.model.reload(currNode);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        AbstractFileNode currNode = (AbstractFileNode)event.getPath().getLastPathComponent();
        if (currNode.getChildCount() > 0) {
            currNode.removeAllChildren();
            currNode.add(this.nodeFactory.create(null, FOLDER_SLUG));
        }
        this.model.reload(currNode);
    }

    protected void setTree(FileDisplayTree resultTree) {
        this.resultTree = resultTree;
    }

    private void add(AbstractFileNode currNode, Set<String> children, HashMap<String, FileDisplayTree> map, boolean folders) {
        ArrayList<String> sortedChildren = new ArrayList<String>(children);
        Collections.sort(sortedChildren);
        for (String child : sortedChildren) {
            AbstractFileNode childNode;
            int childrenSize = map.get(child).getChildren().size();
            if ((!folders || childrenSize <= 0) && (folders || childrenSize != 0) || (childNode = this.nodeFactory.create(map.get(child).getFilePath(), child)).excludeFromTree()) continue;
            if (folders) {
                childNode.add(this.nodeFactory.create(null, FOLDER_SLUG));
            }
            currNode.add(childNode);
            if (folders) {
                childNode.setToolTipText(HTML.wrap(Resources.__("mainNodeFolderTT", map.get(child).size(), StringUtils.getFormattedBytes(map.get(child).fileSize()))));
                continue;
            }
            childNode.setToolTipText(HTML.wrap(Resources.__("mainNodeFileTT", StringUtils.getFormattedBytes(map.get(child).fileSize()))));
        }
    }
}

